/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.kafka.common.TopicIdAndPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class TopicIdPartitionLeaderStrategy
implements AdminApiLookupStrategy<TopicIdAndPartition> {
    private static final ApiRequestScope SINGLE_REQUEST_SCOPE = new ApiRequestScope(){};
    private final Logger log;
    private final boolean tolerateUnknownTopics;

    public TopicIdPartitionLeaderStrategy(LogContext logContext, boolean tolerateUnknownTopics) {
        this.log = logContext.logger(TopicIdPartitionLeaderStrategy.class);
        this.tolerateUnknownTopics = tolerateUnknownTopics;
    }

    @Override
    public ApiRequestScope lookupScope(TopicIdAndPartition key) {
        return SINGLE_REQUEST_SCOPE;
    }

    public MetadataRequest.Builder buildRequest(Set<TopicIdAndPartition> partitions) {
        MetadataRequestData request = new MetadataRequestData();
        request.setAllowAutoTopicCreation(false);
        partitions.stream().map(TopicIdAndPartition::topicId).distinct().forEach(topicId -> request.topics().add(new MetadataRequestData.MetadataRequestTopic().setTopicId((Uuid)topicId)));
        return new MetadataRequest.Builder(request);
    }

    private void handleTopicError(TopicAndUuid topic, Errors topicError, Set<TopicIdAndPartition> requestPartitions, Map<TopicIdAndPartition, Throwable> failed) {
        switch (topicError) {
            case UNKNOWN_TOPIC_OR_PARTITION: {
                if (!this.tolerateUnknownTopics) {
                    this.log.error("Received unknown topic error for topic {}", (Object)topic, (Object)topicError.exception());
                    this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> topicError.exception("Failed to fetch metadata for partition " + String.valueOf(tp) + " because metadata for topic `" + String.valueOf(topic) + "` could not be found"));
                    break;
                }
            }
            case LEADER_NOT_AVAILABLE: 
            case BROKER_NOT_AVAILABLE: {
                this.log.debug("Metadata request for topic {} returned topic-level error {}. Will retry", (Object)topic, (Object)topicError);
                break;
            }
            case TOPIC_AUTHORIZATION_FAILED: {
                this.log.error("Received authorization failure for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> new TopicAuthorizationException("Failed to fetch metadata for partition " + String.valueOf(tp) + " due to topic authorization failure", Collections.singleton(topic.name)));
                break;
            }
            case INVALID_TOPIC_EXCEPTION: {
                this.log.error("Received invalid topic error for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> new InvalidTopicException("Failed to fetch metadata for partition " + String.valueOf(tp) + " due to invalid topic `" + String.valueOf(topic) + "`", Collections.singleton(topic.name)));
                break;
            }
            default: {
                this.log.error("Received unexpected error for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> topicError.exception("Failed to fetch metadata for partition " + String.valueOf(tp) + " due to unexpected error for topic `" + String.valueOf(topic) + "`"));
            }
        }
    }

    private void failAllPartitionsForTopic(TopicAndUuid topic, Set<TopicIdAndPartition> partitions, Map<TopicIdAndPartition, Throwable> failed, Function<TopicIdAndPartition, Throwable> exceptionGenerator) {
        partitions.stream().filter(tp -> tp.topicId().equals(topic.id)).forEach(tp -> failed.put((TopicIdAndPartition)tp, (Throwable)exceptionGenerator.apply((TopicIdAndPartition)tp)));
    }

    private void handlePartitionError(TopicIdAndPartition topicPartition, Errors partitionError, Map<TopicIdAndPartition, Throwable> failed) {
        switch (partitionError) {
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case LEADER_NOT_AVAILABLE: 
            case BROKER_NOT_AVAILABLE: 
            case NOT_LEADER_OR_FOLLOWER: 
            case REPLICA_NOT_AVAILABLE: 
            case KAFKA_STORAGE_ERROR: {
                this.log.debug("Metadata request for partition {} returned partition-level error {}. Will retry", (Object)topicPartition, (Object)partitionError);
                break;
            }
            default: {
                this.log.error("Received unexpected error for partition {} in `Metadata` response", (Object)topicPartition, (Object)partitionError.exception());
                failed.put(topicPartition, partitionError.exception("Unexpected error during metadata lookup for " + String.valueOf(topicPartition)));
            }
        }
    }

    @Override
    public AdminApiLookupStrategy.LookupResult<TopicIdAndPartition> handleResponse(Set<TopicIdAndPartition> requestPartitions, AbstractResponse abstractResponse) {
        MetadataResponse response = (MetadataResponse)abstractResponse;
        HashMap<TopicIdAndPartition, Throwable> failed = new HashMap<TopicIdAndPartition, Throwable>();
        HashMap<TopicIdAndPartition, Integer> mapped = new HashMap<TopicIdAndPartition, Integer>();
        for (MetadataResponseData.MetadataResponseTopic topicMetadata : response.data().topics()) {
            TopicAndUuid topic = new TopicAndUuid(topicMetadata.name(), topicMetadata.topicId());
            Errors topicError = Errors.forCode(topicMetadata.errorCode());
            if (topicError != Errors.NONE) {
                this.handleTopicError(topic, topicError, requestPartitions, failed);
                continue;
            }
            for (MetadataResponseData.MetadataResponsePartition partitionMetadata : topicMetadata.partitions()) {
                TopicIdAndPartition topicPartition = new TopicIdAndPartition(topic.id, partitionMetadata.partitionIndex());
                Errors partitionError = Errors.forCode(partitionMetadata.errorCode());
                if (!requestPartitions.contains(topicPartition)) continue;
                if (partitionError != Errors.NONE) {
                    this.handlePartitionError(topicPartition, partitionError, failed);
                    continue;
                }
                int leaderId = partitionMetadata.leaderId();
                if (leaderId >= 0) {
                    mapped.put(topicPartition, leaderId);
                    continue;
                }
                this.log.debug("Metadata request for {} returned no error, but the leader is unknown. Will retry", (Object)topicPartition);
            }
        }
        return new AdminApiLookupStrategy.LookupResult<TopicIdAndPartition>(failed, mapped);
    }

    private static class TopicAndUuid {
        private final String name;
        private final Uuid id;

        private TopicAndUuid(String name, Uuid id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return String.format("%s:%s", this.name, this.id);
        }
    }
}

