/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;

public class ClientAssertionHttpRequestFormatter
implements HttpRequestFormatter,
Closeable {
    private final ClientAssertion clientAssertion;
    private final String clientId;
    private final String scope;

    ClientAssertionHttpRequestFormatter(ClientAssertion clientAssertion, String clientId, String scope) {
        this.clientAssertion = clientAssertion;
        this.clientId = clientId;
        this.scope = scope;
    }

    @Override
    public Map<String, String> formatHeaders() throws JwtRetrieverException {
        return Map.of();
    }

    @Override
    public String formatBody() {
        StringBuilder requestParameters = new StringBuilder();
        requestParameters.append("client_assertion_type=").append("urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer");
        requestParameters.append("&client_assertion=").append(this.clientAssertion.getJwt());
        requestParameters.append("&grant_type=client_credentials");
        if (this.clientId != null && !this.clientId.isEmpty()) {
            requestParameters.append("&client_id=").append(this.clientId);
        }
        if (this.scope != null && !this.scope.trim().isEmpty()) {
            String encodedScope = URLEncoder.encode(this.scope.trim(), StandardCharsets.UTF_8);
            requestParameters.append("&scope=").append(encodedScope);
        }
        return String.valueOf(requestParameters);
    }

    @Override
    public void close() throws IOException {
        this.clientAssertion.close();
    }
}

