/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CreateClusterLinksRequestData
implements ApiMessage {
    List<EntryData> entries;
    boolean validateOnly;
    boolean validateLink;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public CreateClusterLinksRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public CreateClusterLinksRequestData() {
        this.entries = new ArrayList<EntryData>(0);
        this.validateOnly = false;
        this.validateLink = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10002;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entries was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new EntryData(_readable, _version, _context));
        }
        this.entries = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.validateLink = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.entries.size() + 1);
        for (EntryData entriesElement : this.entries) {
            entriesElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeByte(this.validateLink ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.entries.size() + 1));
        for (EntryData entriesElement : this.entries) {
            entriesElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(1);
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateClusterLinksRequestData)) {
            return false;
        }
        CreateClusterLinksRequestData other = (CreateClusterLinksRequestData)obj;
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.validateLink != other.validateLink) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.validateLink ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public CreateClusterLinksRequestData duplicate() {
        CreateClusterLinksRequestData _duplicate = new CreateClusterLinksRequestData();
        ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
        for (EntryData _element : this.entries) {
            newEntries.add(_element.duplicate());
        }
        _duplicate.entries = newEntries;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.validateLink = this.validateLink;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "CreateClusterLinksRequestData(entries=" + MessageUtil.deepToString(this.entries.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", validateLink=" + (this.validateLink ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public boolean validateLink() {
        return this.validateLink;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateClusterLinksRequestData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public CreateClusterLinksRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public CreateClusterLinksRequestData setValidateLink(boolean v) {
        this.validateLink = v;
        return this;
    }

    public CreateClusterLinksRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("entries", new CompactArrayOf(EntryData.SCHEMA_0), "The cluster link entries to create."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("validate_link", Type.BOOLEAN, "Whether to validate the links to the clusters before creation."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_2 = new Schema(new Field("entries", new CompactArrayOf(EntryData.SCHEMA_2), "The cluster link entries to create."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("validate_link", Type.BOOLEAN, "Whether to validate the links to the clusters before creation."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("entries", new CompactArrayOf(EntryData.SCHEMA_3), "The cluster link entries to create."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("validate_link", Type.BOOLEAN, "Whether to validate the links to the clusters before creation."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class EntryData
    implements Message {
        String linkName;
        Uuid linkId;
        String clusterId;
        String tenantPrefix;
        List<ConfigData> configs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public EntryData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EntryData() {
            this.linkName = "";
            this.linkId = Uuid.ZERO_UUID;
            this.clusterId = null;
            this.tenantPrefix = null;
            this.configs = new ArrayList<ConfigData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
            this.linkId = _version >= 3 ? _readable.readUuid() : Uuid.ZERO_UUID;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.clusterId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clusterId had invalid length " + length);
                }
                this.clusterId = _readable.readString(length);
            }
            if (_version >= 2) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.tenantPrefix = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field tenantPrefix had invalid length " + length);
                    }
                    this.tenantPrefix = _readable.readString(length);
                }
            } else {
                this.tenantPrefix = null;
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field configs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ConfigData> newCollection = new ArrayList<ConfigData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ConfigData(_readable, _version, _context));
            }
            this.configs = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _writable.writeUuid(this.linkId);
            }
            if (this.clusterId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 2) {
                if (this.tenantPrefix == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.tenantPrefix);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            } else if (this.tenantPrefix != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default tenantPrefix at version " + _version);
            }
            _writable.writeUnsignedVarint(this.configs.size() + 1);
            _stringBytes = this.configs.iterator();
            while (_stringBytes.hasNext()) {
                ConfigData configsElement = (ConfigData)_stringBytes.next();
                configsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            byte[] _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (_version >= 3) {
                _size.addBytes(16);
            }
            if (this.clusterId == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterId, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_version >= 2) {
                if (this.tenantPrefix == null) {
                    _size.addBytes(1);
                } else {
                    _stringBytes = this.tenantPrefix.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'tenantPrefix' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.tenantPrefix, _stringBytes);
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1));
            for (ConfigData configsElement : this.configs) {
                configsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
                return false;
            }
            if (this.tenantPrefix == null ? other.tenantPrefix != null : !this.tenantPrefix.equals(other.tenantPrefix)) {
                return false;
            }
            if (this.configs == null ? other.configs != null : !this.configs.equals(other.configs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + this.linkId.hashCode();
            hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
            hashCode = 31 * hashCode + (this.tenantPrefix == null ? 0 : this.tenantPrefix.hashCode());
            hashCode = 31 * hashCode + (this.configs == null ? 0 : this.configs.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            _duplicate.linkName = this.linkName;
            _duplicate.linkId = this.linkId;
            _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
            _duplicate.tenantPrefix = this.tenantPrefix == null ? null : this.tenantPrefix;
            ArrayList<ConfigData> newConfigs = new ArrayList<ConfigData>(this.configs.size());
            for (ConfigData _element : this.configs) {
                newConfigs.add(_element.duplicate());
            }
            _duplicate.configs = newConfigs;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(linkName=" + (String)(this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", linkId=" + this.linkId.toString() + ", clusterId=" + (String)(this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", tenantPrefix=" + (String)(this.tenantPrefix == null ? "null" : "'" + this.tenantPrefix.toString() + "'") + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ")";
        }

        public String linkName() {
            return this.linkName;
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public String clusterId() {
            return this.clusterId;
        }

        public String tenantPrefix() {
            return this.tenantPrefix;
        }

        public List<ConfigData> configs() {
            return this.configs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public EntryData setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }

        public EntryData setClusterId(String v) {
            this.clusterId = v;
            return this;
        }

        public EntryData setTenantPrefix(String v) {
            this.tenantPrefix = v;
            return this;
        }

        public EntryData setConfigs(List<ConfigData> v) {
            this.configs = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The ID of the cluster link, or null if it should not be validated."), new Field("configs", new CompactArrayOf(ConfigData.SCHEMA_0), "The initial configuration values."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_2 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The ID of the cluster link, or null if it should not be validated."), new Field("tenant_prefix", Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null"), new Field("configs", new CompactArrayOf(ConfigData.SCHEMA_0), "The initial configuration values."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_4 = SCHEMA_3 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The id assigned to cluster link. Clients may specify this for source link creation and second side of a bidirectional link."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The ID of the cluster link, or null if it should not be validated."), new Field("tenant_prefix", Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null"), new Field("configs", new CompactArrayOf(ConfigData.SCHEMA_0), "The initial configuration values."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class ConfigData
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public ConfigData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ConfigData() {
            this.key = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ConfigData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ConfigData");
            }
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConfigData)) {
                return false;
            }
            ConfigData other = (ConfigData)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public ConfigData duplicate() {
            ConfigData _duplicate = new ConfigData();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "ConfigData(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ConfigData setKey(String v) {
            this.key = v;
            return this;
        }

        public ConfigData setValue(String v) {
            this.value = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("key", Type.COMPACT_STRING, "The configuration key."), new Field("value", Type.COMPACT_STRING, "The configuration value."), Field.TaggedFieldsSection.of(new Object[0])))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

