/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.UnalignedFileRecords;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnalignedFileRecordsTest {
    private byte[][] values = new byte[][]{"foo".getBytes(), "bar".getBytes()};
    private FileRecords fileRecords;

    @BeforeEach
    public void setup() throws IOException {
        this.fileRecords = this.createFileRecords(this.values);
    }

    @AfterEach
    public void cleanup() throws IOException {
        this.fileRecords.close();
    }

    @Test
    public void testWriteTo() throws IOException {
        ByteBufferChannel channel = new ByteBufferChannel(this.fileRecords.sizeInBytes());
        int size = this.fileRecords.sizeInBytes();
        UnalignedFileRecords records1 = this.fileRecords.sliceUnaligned(0, size / 2);
        UnalignedFileRecords records2 = this.fileRecords.sliceUnaligned(size / 2, size - size / 2);
        records1.writeTo((TransferableChannel)channel, 0L, records1.sizeInBytes());
        records2.writeTo((TransferableChannel)channel, 0L, records2.sizeInBytes());
        channel.close();
        Iterator records = MemoryRecords.readableRecords((ByteBuffer)channel.buffer()).records().iterator();
        for (byte[] value : this.values) {
            Assertions.assertTrue((boolean)records.hasNext());
            Assertions.assertEquals((Object)((Record)records.next()).value(), (Object)ByteBuffer.wrap(value));
        }
    }

    private FileRecords createFileRecords(byte[][] values) throws IOException {
        FileRecords fileRecords = FileRecords.open((File)TestUtils.tempFile());
        for (byte[] value : values) {
            fileRecords.append(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(value)}));
        }
        return fileRecords;
    }
}

