/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KafkaMetricsContextTest {
    private static final String SAMPLE_NAMESPACE = "sample-ns";
    private static final String LABEL_A_KEY = "label-a";
    private static final String LABEL_A_VALUE = "label-a-value";
    private String namespace;
    private Map<String, String> labels;
    private KafkaMetricsContext context;

    @BeforeEach
    public void beforeEach() {
        this.namespace = SAMPLE_NAMESPACE;
        this.labels = new HashMap<String, String>();
        this.labels.put(LABEL_A_KEY, LABEL_A_VALUE);
    }

    @Test
    public void testCreationWithValidNamespaceAndNoLabels() {
        this.labels.clear();
        this.context = new KafkaMetricsContext(this.namespace, this.labels);
        Assertions.assertEquals((int)1, (int)this.context.contextLabels().size());
        Assertions.assertEquals((Object)this.namespace, this.context.contextLabels().get("_namespace"));
    }

    @Test
    public void testCreationWithValidNamespaceAndLabels() {
        this.context = new KafkaMetricsContext(this.namespace, this.labels);
        Assertions.assertEquals((int)2, (int)this.context.contextLabels().size());
        Assertions.assertEquals((Object)this.namespace, this.context.contextLabels().get("_namespace"));
        Assertions.assertEquals((Object)LABEL_A_VALUE, this.context.contextLabels().get(LABEL_A_KEY));
    }

    @Test
    public void testCreationWithValidNamespaceAndNullLabelValues() {
        this.labels.put(LABEL_A_KEY, null);
        this.context = new KafkaMetricsContext(this.namespace, this.labels);
        Assertions.assertEquals((int)2, (int)this.context.contextLabels().size());
        Assertions.assertEquals((Object)this.namespace, this.context.contextLabels().get("_namespace"));
        Assertions.assertNull(this.context.contextLabels().get(LABEL_A_KEY));
    }

    @Test
    public void testCreationWithNullNamespaceAndLabels() {
        this.context = new KafkaMetricsContext(null, this.labels);
        Assertions.assertEquals((int)2, (int)this.context.contextLabels().size());
        Assertions.assertNull(this.context.contextLabels().get("_namespace"));
        Assertions.assertEquals((Object)LABEL_A_VALUE, this.context.contextLabels().get(LABEL_A_KEY));
    }

    @Test
    public void testKafkaMetricsContextLabelsAreImmutable() {
        this.context = new KafkaMetricsContext(this.namespace, this.labels);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.contextLabels().clear());
    }
}

