/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.util.List;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerScopeUtils;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerScopeUtilsTest {
    @Test
    public void validScope() {
        for (String validScope : new String[]{"", "   ", "scope1", " scope1 ", "scope1 Scope2", "scope1   Scope2"}) {
            List parsedScope = OAuthBearerScopeUtils.parseScope((String)validScope);
            if (validScope.trim().isEmpty()) {
                Assert.assertTrue((boolean)parsedScope.isEmpty());
                continue;
            }
            if (validScope.contains("Scope2")) {
                Assert.assertTrue((parsedScope.size() == 2 && ((String)parsedScope.get(0)).equals("scope1") && ((String)parsedScope.get(1)).equals("Scope2") ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((parsedScope.size() == 1 && ((String)parsedScope.get(0)).equals("scope1") ? 1 : 0) != 0);
        }
    }

    @Test
    public void invalidScope() {
        for (String invalidScope : new String[]{"\"foo", "\\foo"}) {
            try {
                OAuthBearerScopeUtils.parseScope((String)invalidScope);
                Assert.fail((String)("did not detect invalid scope: " + invalidScope));
            }
            catch (OAuthBearerConfigException oAuthBearerConfigException) {
                // empty catch block
            }
        }
    }
}

