/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaslExtensionsTest {
    Map<String, String> map;

    @Before
    public void setUp() {
        this.map = new HashMap<String, String>();
        this.map.put("what", "42");
        this.map.put("who", "me");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReturnedMapIsImmutable() {
        SaslExtensions extensions = new SaslExtensions(this.map);
        extensions.map().put("hello", "test");
    }

    @Test
    public void testCannotAddValueToMapReferenceAndGetFromExtensions() {
        SaslExtensions extensions = new SaslExtensions(this.map);
        Assert.assertNull(extensions.map().get("hello"));
        this.map.put("hello", "42");
        Assert.assertNull(extensions.map().get("hello"));
    }
}

