/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.resource;

import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class ResourceTypeTest {
    private static final AclResourceTypeTestInfo[] INFOS = new AclResourceTypeTestInfo[]{new AclResourceTypeTestInfo(ResourceType.UNKNOWN, 0, "unknown", true), new AclResourceTypeTestInfo(ResourceType.ANY, 1, "any", false), new AclResourceTypeTestInfo(ResourceType.TOPIC, 2, "topic", false), new AclResourceTypeTestInfo(ResourceType.GROUP, 3, "group", false), new AclResourceTypeTestInfo(ResourceType.CLUSTER, 4, "cluster", false), new AclResourceTypeTestInfo(ResourceType.TRANSACTIONAL_ID, 5, "transactional_id", false), new AclResourceTypeTestInfo(ResourceType.DELEGATION_TOKEN, 6, "delegation_token", false)};

    @Test
    public void testIsUnknown() {
        for (AclResourceTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)(info.resourceType + " was supposed to have unknown == " + info.unknown), (Object)info.unknown, (Object)info.resourceType.isUnknown());
        }
    }

    @Test
    public void testCode() {
        Assert.assertEquals((long)ResourceType.values().length, (long)INFOS.length);
        for (AclResourceTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)(info.resourceType + " was supposed to have code == " + info.code), (long)info.code, (long)info.resourceType.code());
            Assert.assertEquals((String)("AclResourceType.fromCode(" + info.code + ") was supposed to be " + info.resourceType), (Object)info.resourceType, (Object)ResourceType.fromCode((byte)((byte)info.code)));
        }
        Assert.assertEquals((Object)ResourceType.UNKNOWN, (Object)ResourceType.fromCode((byte)120));
    }

    @Test
    public void testName() {
        for (AclResourceTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)("ResourceType.fromString(" + info.name + ") was supposed to be " + info.resourceType), (Object)info.resourceType, (Object)ResourceType.fromString((String)info.name));
        }
        Assert.assertEquals((Object)ResourceType.UNKNOWN, (Object)ResourceType.fromString((String)"something"));
    }

    @Test
    public void testExhaustive() {
        Assert.assertEquals((long)INFOS.length, (long)ResourceType.values().length);
        for (int i = 0; i < INFOS.length; ++i) {
            Assert.assertEquals((Object)INFOS[i].resourceType, (Object)ResourceType.values()[i]);
        }
    }

    private static class AclResourceTypeTestInfo {
        private final ResourceType resourceType;
        private final int code;
        private final String name;
        private final boolean unknown;

        AclResourceTypeTestInfo(ResourceType resourceType, int code, String name, boolean unknown) {
            this.resourceType = resourceType;
            this.code = code;
            this.name = name;
            this.unknown = unknown;
        }
    }
}

