/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RequestHeaderTest {
    @Test
    public void testSerdeControlledShutdownV0() {
        int correlationId = 2342;
        ByteBuffer rawBuffer = ByteBuffer.allocate(32);
        rawBuffer.putShort(ApiKeys.CONTROLLED_SHUTDOWN.id);
        rawBuffer.putShort((short)0);
        rawBuffer.putInt(correlationId);
        rawBuffer.flip();
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)rawBuffer);
        Assert.assertEquals((Object)ApiKeys.CONTROLLED_SHUTDOWN, (Object)deserialized.apiKey());
        Assert.assertEquals((long)0L, (long)deserialized.apiVersion());
        Assert.assertEquals((long)correlationId, (long)deserialized.correlationId());
        Assert.assertEquals((Object)"", (Object)deserialized.clientId());
        Assert.assertEquals((long)0L, (long)deserialized.headerVersion());
        Struct serialized = deserialized.toStruct();
        ByteBuffer serializedBuffer = TestUtils.toBuffer(serialized);
        Assert.assertEquals((long)ApiKeys.CONTROLLED_SHUTDOWN.id, (long)serializedBuffer.getShort(0));
        Assert.assertEquals((long)0L, (long)serializedBuffer.getShort(2));
        Assert.assertEquals((long)correlationId, (long)serializedBuffer.getInt(4));
        Assert.assertEquals((long)8L, (long)serializedBuffer.limit());
    }

    @Test
    public void testRequestHeaderV1() {
        RequestHeader header = new RequestHeader(ApiKeys.FIND_COORDINATOR, 1, "", 10);
        Assert.assertEquals((long)1L, (long)header.headerVersion());
        ByteBuffer buffer = TestUtils.toBuffer(header.toStruct());
        Assert.assertEquals((long)10L, (long)buffer.remaining());
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((Object)header, (Object)deserialized);
    }

    @Test
    public void testRequestHeaderV2() {
        RequestHeader header = new RequestHeader(ApiKeys.CREATE_DELEGATION_TOKEN, 2, "", 10);
        Assert.assertEquals((long)2L, (long)header.headerVersion());
        ByteBuffer buffer = TestUtils.toBuffer(header.toStruct());
        Assert.assertEquals((long)11L, (long)buffer.remaining());
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((Object)header, (Object)deserialized);
    }
}

