/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.net.InetAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelBuildersTest {
    @Test
    public void testCreateOldPrincipalBuilder() throws Exception {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        HashMap<String, Class<OldPrincipalBuilder>> configs = new HashMap<String, Class<OldPrincipalBuilder>>();
        configs.put("principal.builder.class", OldPrincipalBuilder.class);
        KafkaPrincipalBuilder builder = ChannelBuilders.createPrincipalBuilder(configs, (TransportLayer)transportLayer, (Authenticator)authenticator, null, null);
        Assert.assertTrue((boolean)OldPrincipalBuilder.configured);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new PlaintextAuthenticationContext(InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"bob", (Object)principal.getName());
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
    }

    @Test
    public void testCreateConfigurableKafkaPrincipalBuilder() {
        HashMap<String, Class<ConfigurableKafkaPrincipalBuilder>> configs = new HashMap<String, Class<ConfigurableKafkaPrincipalBuilder>>();
        configs.put("principal.builder.class", ConfigurableKafkaPrincipalBuilder.class);
        KafkaPrincipalBuilder builder = ChannelBuilders.createPrincipalBuilder(configs, null, null, null, null);
        Assert.assertTrue((boolean)(builder instanceof ConfigurableKafkaPrincipalBuilder));
        Assert.assertTrue((boolean)((ConfigurableKafkaPrincipalBuilder)builder).configured);
    }

    @Test
    public void testChannelBuilderConfigs() {
        Properties props = new Properties();
        props.put("listener.name.listener1.gssapi.sasl.kerberos.service.name", "testkafka");
        props.put("listener.name.listener1.sasl.kerberos.service.name", "testkafkaglobal");
        props.put("plain.sasl.server.callback.handler.class", "callback");
        props.put("listener.name.listener1.gssapi.config1.key", "custom.config1");
        props.put("custom.config2.key", "custom.config2");
        TestSecurityConfig securityConfig = new TestSecurityConfig(props);
        Map configs = ChannelBuilders.channelBuilderConfigs((AbstractConfig)securityConfig, (ListenerName)new ListenerName("listener1"));
        Assert.assertNull(configs.get("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assert.assertEquals(configs.get("gssapi.sasl.kerberos.service.name"), (Object)"testkafka");
        Assert.assertEquals(configs.get("sasl.kerberos.service.name"), (Object)"testkafkaglobal");
        Assert.assertNull(configs.get("listener.name.listener1.sasl.kerberos.service.name"));
        Assert.assertNull(configs.get("plain.sasl.server.callback.handler.class"));
        Assert.assertEquals(configs.get("listener.name.listener1.gssapi.config1.key"), (Object)"custom.config1");
        Assert.assertEquals(configs.get("custom.config2.key"), (Object)"custom.config2");
        configs = ChannelBuilders.channelBuilderConfigs((AbstractConfig)securityConfig, null);
        Assert.assertEquals(configs.get("listener.name.listener1.gssapi.sasl.kerberos.service.name"), (Object)"testkafka");
        Assert.assertNull(configs.get("gssapi.sasl.kerberos.service.name"));
        Assert.assertEquals(configs.get("listener.name.listener1.sasl.kerberos.service.name"), (Object)"testkafkaglobal");
        Assert.assertNull(configs.get("sasl.kerberos.service.name"));
        Assert.assertEquals(configs.get("plain.sasl.server.callback.handler.class"), (Object)"callback");
        Assert.assertEquals(configs.get("listener.name.listener1.gssapi.config1.key"), (Object)"custom.config1");
        Assert.assertEquals(configs.get("custom.config2.key"), (Object)"custom.config2");
    }

    public static class ConfigurableKafkaPrincipalBuilder
    implements KafkaPrincipalBuilder,
    Configurable {
        private boolean configured = false;

        public void configure(Map<String, ?> configs) {
            this.configured = true;
        }

        public KafkaPrincipal build(AuthenticationContext context) {
            return null;
        }
    }

    public static class OldPrincipalBuilder
    implements PrincipalBuilder {
        private static boolean configured = false;
        private static final String PRINCIPAL_NAME = "bob";

        public void configure(Map<String, ?> configs) {
            configured = true;
        }

        public Principal buildPrincipal(TransportLayer transportLayer, Authenticator authenticator) throws KafkaException {
            return new Principal(){

                @Override
                public String getName() {
                    return OldPrincipalBuilder.PRINCIPAL_NAME;
                }
            };
        }

        public void close() throws KafkaException {
        }
    }
}

