/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayDeque;
import org.apache.kafka.common.message.SimpleRecordsMessageData;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.RecordsReadable;
import org.apache.kafka.common.protocol.RecordsWritable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MultiRecordsSend;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.junit.Assert;
import org.junit.Test;

public class RecordsSerdeTest {
    @Test
    public void testSerdeRecords() throws Exception {
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo").setRecordSet((BaseRecords)records);
        this.testAllRoundTrips(message);
    }

    @Test
    public void testSerdeNullRecords() throws Exception {
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo");
        Assert.assertNull((Object)message.recordSet());
        this.testAllRoundTrips(message);
    }

    @Test
    public void testSerdeEmptyRecords() throws Exception {
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo").setRecordSet((BaseRecords)MemoryRecords.EMPTY);
        this.testAllRoundTrips(message);
    }

    private void testAllRoundTrips(SimpleRecordsMessageData message) throws Exception {
        for (short version = 0; version <= 1; version = (short)(version + 1)) {
            this.testRoundTrip(message, version);
        }
    }

    private void testRoundTrip(SimpleRecordsMessageData message, short version) throws IOException {
        ByteBuffer buf = this.serialize(message, version);
        SimpleRecordsMessageData message2 = this.deserialize(buf.duplicate(), version);
        Assert.assertEquals((Object)message, (Object)message2);
        Assert.assertEquals((long)message.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)buf, (Object)this.serializeThroughStruct(message, version));
        SimpleRecordsMessageData messageFromStruct = this.deserializeThroughStruct(buf.duplicate(), version);
        Assert.assertEquals((Object)message, (Object)messageFromStruct);
        Assert.assertEquals((long)message.hashCode(), (long)messageFromStruct.hashCode());
    }

    private SimpleRecordsMessageData deserializeThroughStruct(ByteBuffer buffer, short version) {
        Schema schema = SimpleRecordsMessageData.SCHEMAS[version];
        Struct struct = schema.read(buffer);
        return new SimpleRecordsMessageData(struct, version);
    }

    private SimpleRecordsMessageData deserialize(ByteBuffer buffer, short version) {
        RecordsReadable readable = new RecordsReadable(buffer);
        return new SimpleRecordsMessageData((Readable)readable, version);
    }

    private ByteBuffer serializeThroughStruct(SimpleRecordsMessageData message, short version) {
        Struct struct = message.toStruct(version);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        return buffer;
    }

    private ByteBuffer serialize(SimpleRecordsMessageData message, short version) throws IOException {
        ArrayDeque sends = new ArrayDeque();
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int totalMessageSize = message.size(cache, version);
        int recordsSize = message.recordSet() == null ? 0 : message.recordSet().sizeInBytes();
        RecordsWritable writer = new RecordsWritable("0", totalMessageSize - recordsSize, sends::add);
        message.write((Writable)writer, cache, version);
        writer.flush();
        MultiRecordsSend send = new MultiRecordsSend("0", sends);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        return channel.buffer();
    }
}

