/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ProduceResponseData
implements ApiMessage {
    List<TopicProduceResponse> responses;
    int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)TopicProduceResponse.SCHEMA_0), "Each produce response")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)TopicProduceResponse.SCHEMA_0), "Each produce response"), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 8;

    public ProduceResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ProduceResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ProduceResponseData() {
        this.responses = new ArrayList<TopicProduceResponse>(0);
        this.throttleTimeMs = 0;
    }

    public short apiKey() {
        return 0;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 8;
    }

    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field responses was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicProduceResponse> newCollection = new ArrayList<TopicProduceResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicProduceResponse(_readable, _version));
        }
        this.responses = newCollection;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        RawTaggedFieldWriter _rawWriter;
        int _numTaggedFields = 0;
        _writable.writeInt(this.responses.size());
        for (TopicProduceResponse responsesElement : this.responses) {
            responsesElement.write(_writable, _cache, _version);
        }
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("responses");
        this.responses = new ArrayList<TopicProduceResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.responses.add(new TopicProduceResponse((Struct)nestedObject, _version));
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.responses.size()];
        int i = 0;
        for (TopicProduceResponse element : this.responses) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("responses", (Object)_nestedObjects);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (TopicProduceResponse responsesElement : this.responses) {
            _arraySize += responsesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 1) {
            _size += 4;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceResponseData)) {
            return false;
        }
        ProduceResponseData other = (ProduceResponseData)obj;
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public ProduceResponseData duplicate() {
        ProduceResponseData _duplicate = new ProduceResponseData();
        ArrayList<TopicProduceResponse> newResponses = new ArrayList<TopicProduceResponse>(this.responses.size());
        for (TopicProduceResponse _element : this.responses) {
            newResponses.add(_element.duplicate());
        }
        _duplicate.responses = newResponses;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "ProduceResponseData(responses=" + MessageUtil.deepToString(this.responses.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public List<TopicProduceResponse> responses() {
        return this.responses;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProduceResponseData setResponses(List<TopicProduceResponse> v) {
        this.responses = v;
        return this;
    }

    public ProduceResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)TopicProduceResponse.SCHEMA_2), "Each produce response"), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")}));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)TopicProduceResponse.SCHEMA_5), "Each produce response"), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")}));
        SCHEMA_8 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)TopicProduceResponse.SCHEMA_8), "Each produce response"), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
    }

    public static class BatchIndexAndErrorMessage
    implements Message {
        int batchIndex;
        String batchIndexErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_8 = new Schema(new Field[]{new Field("batch_index", (Type)Type.INT32, "The batch index of the record that cause the batch to be dropped"), new Field("batch_index_error_message", (Type)Type.NULLABLE_STRING, "The error message of the record that caused the batch to be dropped")});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, SCHEMA_8};
        public static final short LOWEST_SUPPORTED_VERSION = 8;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public BatchIndexAndErrorMessage(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public BatchIndexAndErrorMessage(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public BatchIndexAndErrorMessage() {
            this.batchIndex = 0;
            this.batchIndexErrorMessage = null;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 8;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BatchIndexAndErrorMessage");
            }
            this.batchIndex = _readable.readInt();
            short length = _readable.readShort();
            if (length < 0) {
                this.batchIndexErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field batchIndexErrorMessage had invalid length " + length);
                }
                this.batchIndexErrorMessage = _readable.readString((int)length);
            }
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BatchIndexAndErrorMessage");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.batchIndex);
            if (this.batchIndexErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue((Object)this.batchIndexErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BatchIndexAndErrorMessage");
            }
            this._unknownTaggedFields = null;
            this.batchIndex = struct.getInt("batch_index");
            this.batchIndexErrorMessage = struct.getString("batch_index_error_message");
        }

        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BatchIndexAndErrorMessage");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("batch_index", (Object)this.batchIndex);
            struct.set("batch_index_error_message", (Object)this.batchIndexErrorMessage);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BatchIndexAndErrorMessage");
            }
            _size += 4;
            if (this.batchIndexErrorMessage == null) {
                _size += 2;
            } else {
                byte[] _stringBytes = this.batchIndexErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'batchIndexErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.batchIndexErrorMessage, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BatchIndexAndErrorMessage)) {
                return false;
            }
            BatchIndexAndErrorMessage other = (BatchIndexAndErrorMessage)obj;
            if (this.batchIndex != other.batchIndex) {
                return false;
            }
            if (this.batchIndexErrorMessage == null ? other.batchIndexErrorMessage != null : !this.batchIndexErrorMessage.equals(other.batchIndexErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.batchIndex;
            hashCode = 31 * hashCode + (this.batchIndexErrorMessage == null ? 0 : this.batchIndexErrorMessage.hashCode());
            return hashCode;
        }

        public BatchIndexAndErrorMessage duplicate() {
            BatchIndexAndErrorMessage _duplicate = new BatchIndexAndErrorMessage();
            _duplicate.batchIndex = this.batchIndex;
            _duplicate.batchIndexErrorMessage = this.batchIndexErrorMessage == null ? null : this.batchIndexErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BatchIndexAndErrorMessage(batchIndex=" + this.batchIndex + ", batchIndexErrorMessage=" + (this.batchIndexErrorMessage == null ? "null" : "'" + this.batchIndexErrorMessage.toString() + "'") + ")";
        }

        public int batchIndex() {
            return this.batchIndex;
        }

        public String batchIndexErrorMessage() {
            return this.batchIndexErrorMessage;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BatchIndexAndErrorMessage setBatchIndex(int v) {
            this.batchIndex = v;
            return this;
        }

        public BatchIndexAndErrorMessage setBatchIndexErrorMessage(String v) {
            this.batchIndexErrorMessage = v;
            return this;
        }
    }

    public static class PartitionProduceResponse
    implements Message {
        int partitionIndex;
        short errorCode;
        long baseOffset;
        long logAppendTimeMs;
        long logStartOffset;
        List<BatchIndexAndErrorMessage> recordErrors;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public PartitionProduceResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionProduceResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public PartitionProduceResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.baseOffset = 0L;
            this.logAppendTimeMs = -1L;
            this.logStartOffset = -1L;
            this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(0);
            this.errorMessage = null;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 8;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.baseOffset = _readable.readLong();
            this.logAppendTimeMs = _version >= 2 ? _readable.readLong() : -1L;
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            if (_version >= 8) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field recordErrors was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<BatchIndexAndErrorMessage> newCollection = new ArrayList<BatchIndexAndErrorMessage>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new BatchIndexAndErrorMessage(_readable, _version));
                }
                this.recordErrors = newCollection;
            } else {
                this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(0);
            }
            if (_version >= 8) {
                short length = _readable.readShort();
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString((int)length);
                }
            } else {
                this.errorMessage = null;
            }
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            RawTaggedFieldWriter _rawWriter;
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            _writable.writeLong(this.baseOffset);
            if (_version >= 2) {
                _writable.writeLong(this.logAppendTimeMs);
            }
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            }
            if (_version >= 8) {
                _writable.writeInt(this.recordErrors.size());
                for (BatchIndexAndErrorMessage recordErrorsElement : this.recordErrors) {
                    recordErrorsElement.write(_writable, _cache, _version);
                }
            }
            if (_version >= 8) {
                if (this.errorMessage == null) {
                    _writable.writeShort((short)-1);
                } else {
                    byte[] _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
                    _writable.writeShort((short)_stringBytes.length);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceResponse");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.baseOffset = struct.getLong("base_offset");
            this.logAppendTimeMs = _version >= 2 ? struct.getLong("log_append_time_ms") : -1L;
            this.logStartOffset = _version >= 5 ? struct.getLong("log_start_offset") : -1L;
            if (_version >= 8) {
                Object[] _nestedObjects = struct.getArray("record_errors");
                this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.recordErrors.add(new BatchIndexAndErrorMessage((Struct)nestedObject, _version));
                }
            } else {
                this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(0);
            }
            this.errorMessage = _version >= 8 ? struct.getString("error_message") : null;
        }

        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionProduceResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("base_offset", (Object)this.baseOffset);
            if (_version >= 2) {
                struct.set("log_append_time_ms", (Object)this.logAppendTimeMs);
            }
            if (_version >= 5) {
                struct.set("log_start_offset", (Object)this.logStartOffset);
            }
            if (_version >= 8) {
                Struct[] _nestedObjects = new Struct[this.recordErrors.size()];
                int i = 0;
                for (BatchIndexAndErrorMessage element : this.recordErrors) {
                    _nestedObjects[i++] = element.toStruct(_version);
                }
                struct.set("record_errors", (Object)_nestedObjects);
            }
            if (_version >= 8) {
                struct.set("error_message", (Object)this.errorMessage);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionProduceResponse");
            }
            _size += 4;
            _size += 2;
            _size += 8;
            if (_version >= 2) {
                _size += 8;
            }
            if (_version >= 5) {
                _size += 8;
            }
            if (_version >= 8) {
                int _arraySize = 0;
                _arraySize += 4;
                for (BatchIndexAndErrorMessage recordErrorsElement : this.recordErrors) {
                    _arraySize += recordErrorsElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (_version >= 8) {
                if (this.errorMessage == null) {
                    _size += 2;
                } else {
                    byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
                    _size += _stringBytes.length + 2;
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceResponse)) {
                return false;
            }
            PartitionProduceResponse other = (PartitionProduceResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.baseOffset != other.baseOffset) {
                return false;
            }
            if (this.logAppendTimeMs != other.logAppendTimeMs) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.recordErrors == null ? other.recordErrors != null : !this.recordErrors.equals(other.recordErrors)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.baseOffset >> 32) ^ (int)this.baseOffset);
            hashCode = 31 * hashCode + ((int)(this.logAppendTimeMs >> 32) ^ (int)this.logAppendTimeMs);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.recordErrors == null ? 0 : this.recordErrors.hashCode());
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        public PartitionProduceResponse duplicate() {
            PartitionProduceResponse _duplicate = new PartitionProduceResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.baseOffset = this.baseOffset;
            _duplicate.logAppendTimeMs = this.logAppendTimeMs;
            _duplicate.logStartOffset = this.logStartOffset;
            ArrayList<BatchIndexAndErrorMessage> newRecordErrors = new ArrayList<BatchIndexAndErrorMessage>(this.recordErrors.size());
            for (BatchIndexAndErrorMessage _element : this.recordErrors) {
                newRecordErrors.add(_element.duplicate());
            }
            _duplicate.recordErrors = newRecordErrors;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "PartitionProduceResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", baseOffset=" + this.baseOffset + ", logAppendTimeMs=" + this.logAppendTimeMs + ", logStartOffset=" + this.logStartOffset + ", recordErrors=" + MessageUtil.deepToString(this.recordErrors.iterator()) + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public long logAppendTimeMs() {
            return this.logAppendTimeMs;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public List<BatchIndexAndErrorMessage> recordErrors() {
            return this.recordErrors;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionProduceResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionProduceResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionProduceResponse setBaseOffset(long v) {
            this.baseOffset = v;
            return this;
        }

        public PartitionProduceResponse setLogAppendTimeMs(long v) {
            this.logAppendTimeMs = v;
            return this;
        }

        public PartitionProduceResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public PartitionProduceResponse setRecordErrors(List<BatchIndexAndErrorMessage> v) {
            this.recordErrors = v;
            return this;
        }

        public PartitionProduceResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", (Type)Type.INT64, "The base offset.")});
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", (Type)Type.INT64, "The base offset."), new Field("log_append_time_ms", (Type)Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended.")}));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", (Type)Type.INT64, "The base offset."), new Field("log_append_time_ms", (Type)Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", (Type)Type.INT64, "The log start offset.")}));
            SCHEMA_8 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", (Type)Type.INT64, "The base offset."), new Field("log_append_time_ms", (Type)Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", (Type)Type.INT64, "The log start offset."), new Field("record_errors", (Type)new ArrayOf((Type)BatchIndexAndErrorMessage.SCHEMA_8), "The batch indices of records that caused the batch to be dropped"), new Field("error_message", (Type)Type.NULLABLE_STRING, "The global error message summarizing the common root cause of the records that caused the batch to be dropped")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class TopicProduceResponse
    implements Message {
        String name;
        List<PartitionProduceResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public TopicProduceResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicProduceResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TopicProduceResponse() {
            this.name = "";
            this.partitions = new ArrayList<PartitionProduceResponse>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 8;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionProduceResponse> newCollection = new ArrayList<PartitionProduceResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionProduceResponse(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionProduceResponse partitionsElement = (PartitionProduceResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceResponse");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionProduceResponse>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new PartitionProduceResponse((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicProduceResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (PartitionProduceResponse element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicProduceResponse");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (PartitionProduceResponse partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceResponse)) {
                return false;
            }
            TopicProduceResponse other = (TopicProduceResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public TopicProduceResponse duplicate() {
            TopicProduceResponse _duplicate = new TopicProduceResponse();
            _duplicate.name = this.name;
            ArrayList<PartitionProduceResponse> newPartitions = new ArrayList<PartitionProduceResponse>(this.partitions.size());
            for (PartitionProduceResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicProduceResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceResponse> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicProduceResponse setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceResponse setPartitions(List<PartitionProduceResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)PartitionProduceResponse.SCHEMA_0), "Each partition that we produced to within the topic.")});
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)PartitionProduceResponse.SCHEMA_2), "Each partition that we produced to within the topic.")}));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)PartitionProduceResponse.SCHEMA_5), "Each partition that we produced to within the topic.")}));
            SCHEMA_8 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)PartitionProduceResponse.SCHEMA_8), "Each partition that we produced to within the topic.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }
}

