/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class LeaderChangeMessage
implements ApiMessage {
    int leaderId;
    List<Voter> voters;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("leader_id", (Type)Type.INT32, "The ID of the newly elected leader"), new Field("voters", (Type)new CompactArrayOf((Type)Voter.SCHEMA_0), "The voters who voted for the current leader"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public LeaderChangeMessage(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderChangeMessage(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public LeaderChangeMessage() {
        this.leaderId = 0;
        this.voters = new ArrayList<Voter>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.leaderId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field voters was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Voter> newCollection = new ArrayList<Voter>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new Voter(_readable, _version));
        }
        this.voters = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.leaderId);
        _writable.writeUnsignedVarint(this.voters.size() + 1);
        for (Voter votersElement : this.voters) {
            votersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        this.leaderId = struct.getInt("leader_id");
        Object[] _nestedObjects = struct.getArray("voters");
        this.voters = new ArrayList<Voter>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.voters.add(new Voter((Struct)nestedObject, _version));
        }
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("leader_id", (Object)this.leaderId);
        Struct[] _nestedObjects = new Struct[this.voters.size()];
        int i = 0;
        for (Voter element : this.voters) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("voters", (Object)_nestedObjects);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.voters.size() + 1));
        for (Voter votersElement : this.voters) {
            _arraySize += votersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderChangeMessage)) {
            return false;
        }
        LeaderChangeMessage other = (LeaderChangeMessage)obj;
        if (this.leaderId != other.leaderId) {
            return false;
        }
        if (this.voters == null ? other.voters != null : !this.voters.equals(other.voters)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.leaderId;
        hashCode = 31 * hashCode + (this.voters == null ? 0 : this.voters.hashCode());
        return hashCode;
    }

    public LeaderChangeMessage duplicate() {
        LeaderChangeMessage _duplicate = new LeaderChangeMessage();
        _duplicate.leaderId = this.leaderId;
        ArrayList<Voter> newVoters = new ArrayList<Voter>(this.voters.size());
        for (Voter _element : this.voters) {
            newVoters.add(_element.duplicate());
        }
        _duplicate.voters = newVoters;
        return _duplicate;
    }

    public String toString() {
        return "LeaderChangeMessage(leaderId=" + this.leaderId + ", voters=" + MessageUtil.deepToString(this.voters.iterator()) + ")";
    }

    public int leaderId() {
        return this.leaderId;
    }

    public List<Voter> voters() {
        return this.voters;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderChangeMessage setLeaderId(int v) {
        this.leaderId = v;
        return this;
    }

    public LeaderChangeMessage setVoters(List<Voter> v) {
        this.voters = v;
        return this;
    }

    public static class Voter
    implements Message {
        int voterId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("voter_id", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Voter(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Voter(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public Voter() {
            this.voterId = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.voterId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.voterId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.voterId = struct.getInt("voter_id");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("voter_id", (Object)this.voterId);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Voter)) {
                return false;
            }
            Voter other = (Voter)obj;
            if (this.voterId != other.voterId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.voterId;
            return hashCode;
        }

        public Voter duplicate() {
            Voter _duplicate = new Voter();
            _duplicate.voterId = this.voterId;
            return _duplicate;
        }

        public String toString() {
            return "Voter(voterId=" + this.voterId + ")";
        }

        public int voterId() {
            return this.voterId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Voter setVoterId(int v) {
            this.voterId = v;
            return this;
        }
    }
}

