/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class DescribeGroupsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DescribedGroup> groups;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("groups", (Type)new ArrayOf((Type)DescribedGroup.SCHEMA_0), "Each described group.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public DescribeGroupsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeGroupsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeGroupsResponseData() {
        this.throttleTimeMs = 0;
        this.groups = new ArrayList<DescribedGroup>(0);
    }

    public short apiKey() {
        return 15;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribedGroup> newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field groups was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedGroup(_readable, _version));
            }
            this.groups = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field groups was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DescribedGroup>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedGroup(_readable, _version));
            }
            this.groups = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.groups.size() + 1);
            for (DescribedGroup groupsElement : this.groups) {
                groupsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.groups.size());
            for (DescribedGroup groupsElement : this.groups) {
                groupsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("groups");
        this.groups = new ArrayList<DescribedGroup>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.groups.add(new DescribedGroup((Struct)nestedObject, _version));
        }
        if (_version >= 5 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 5) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.groups.size()];
        int i = 0;
        for (DescribedGroup element : this.groups) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("groups", (Object)_nestedObjects);
        if (_version >= 5) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.groups.size() + 1))) : (_arraySize += 4);
        for (DescribedGroup groupsElement : this.groups) {
            _arraySize += groupsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 5) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeGroupsResponseData)) {
            return false;
        }
        DescribeGroupsResponseData other = (DescribeGroupsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    public DescribeGroupsResponseData duplicate() {
        DescribeGroupsResponseData _duplicate = new DescribeGroupsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribedGroup> newGroups = new ArrayList<DescribedGroup>(this.groups.size());
        for (DescribedGroup _element : this.groups) {
            newGroups.add(_element.duplicate());
        }
        _duplicate.groups = newGroups;
        return _duplicate;
    }

    public String toString() {
        return "DescribeGroupsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribedGroup> groups() {
        return this.groups;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeGroupsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeGroupsResponseData setGroups(List<DescribedGroup> v) {
        this.groups = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", (Type)new ArrayOf((Type)DescribedGroup.SCHEMA_0), "Each described group.")});
        SCHEMA_3 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", (Type)new ArrayOf((Type)DescribedGroup.SCHEMA_3), "Each described group.")});
        SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", (Type)new ArrayOf((Type)DescribedGroup.SCHEMA_4), "Each described group.")});
        SCHEMA_5 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", (Type)new CompactArrayOf((Type)DescribedGroup.SCHEMA_5), "Each described group."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class DescribedGroupMember
    implements Message {
        String memberId;
        String groupInstanceId;
        String clientId;
        String clientHost;
        byte[] memberMetadata;
        byte[] memberAssignment;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public DescribedGroupMember(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedGroupMember(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribedGroupMember() {
            this.memberId = "";
            this.groupInstanceId = null;
            this.clientId = "";
            this.clientHost = "";
            this.memberMetadata = Bytes.EMPTY;
            this.memberAssignment = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroupMember");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            if (_version >= 4) {
                length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.groupInstanceId = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                    }
                    this.groupInstanceId = _readable.readString(length);
                }
            } else {
                this.groupInstanceId = null;
            }
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            }
            this.clientHost = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberMetadata was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.memberMetadata = newBytes;
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberAssignment was serialized as null");
            }
            newBytes = _readable.readArray(length);
            this.memberAssignment = newBytes;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.memberId);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 4) {
                if (this.groupInstanceId == null) {
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue((Object)this.groupInstanceId);
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            }
            _stringBytes = _cache.getSerializedValue((Object)this.clientId);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.clientHost);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.memberMetadata.length + 1);
            } else {
                _writable.writeInt(this.memberMetadata.length);
            }
            _writable.writeByteArray(this.memberMetadata);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.memberAssignment.length + 1);
            } else {
                _writable.writeInt(this.memberAssignment.length);
            }
            _writable.writeByteArray(this.memberAssignment);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroupMember");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.memberId = struct.getString("member_id");
            this.groupInstanceId = _version >= 4 ? struct.getString("group_instance_id") : null;
            this.clientId = struct.getString("client_id");
            this.clientHost = struct.getString("client_host");
            this.memberMetadata = struct.getByteArray("member_metadata");
            this.memberAssignment = struct.getByteArray("member_assignment");
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribedGroupMember");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("member_id", (Object)this.memberId);
            if (_version >= 4) {
                struct.set("group_instance_id", (Object)this.groupInstanceId);
            }
            struct.set("client_id", (Object)this.clientId);
            struct.set("client_host", (Object)this.clientHost);
            struct.setByteArray("member_metadata", this.memberMetadata);
            struct.setByteArray("member_assignment", this.memberAssignment);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedGroupMember");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.memberId, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            if (_version >= 4) {
                if (this.groupInstanceId == null) {
                    _size = _version >= 5 ? ++_size : (_size += 2);
                } else {
                    _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue((Object)this.groupInstanceId, _stringBytes);
                    _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
                }
            }
            if ((_stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientId, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientHost, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            int _bytesSize = this.memberMetadata.length;
            _bytesSize = _version >= 5 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.memberMetadata.length + 1))) : (_bytesSize += 4);
            _size += _bytesSize;
            _bytesSize = this.memberAssignment.length;
            _bytesSize = _version >= 5 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.memberAssignment.length + 1))) : (_bytesSize += 4);
            _size += _bytesSize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroupMember)) {
                return false;
            }
            DescribedGroupMember other = (DescribedGroupMember)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (!Arrays.equals(this.memberMetadata, other.memberMetadata)) {
                return false;
            }
            if (!Arrays.equals(this.memberAssignment, other.memberAssignment)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.memberMetadata);
            hashCode = 31 * hashCode + Arrays.hashCode(this.memberAssignment);
            return hashCode;
        }

        public DescribedGroupMember duplicate() {
            DescribedGroupMember _duplicate = new DescribedGroupMember();
            _duplicate.memberId = this.memberId;
            _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
            _duplicate.clientId = this.clientId;
            _duplicate.clientHost = this.clientHost;
            _duplicate.memberMetadata = MessageUtil.duplicate((byte[])this.memberMetadata);
            _duplicate.memberAssignment = MessageUtil.duplicate((byte[])this.memberAssignment);
            return _duplicate;
        }

        public String toString() {
            return "DescribedGroupMember(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", memberMetadata=" + Arrays.toString(this.memberMetadata) + ", memberAssignment=" + Arrays.toString(this.memberAssignment) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public byte[] memberMetadata() {
            return this.memberMetadata;
        }

        public byte[] memberAssignment() {
            return this.memberAssignment;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedGroupMember setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public DescribedGroupMember setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public DescribedGroupMember setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public DescribedGroupMember setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public DescribedGroupMember setMemberMetadata(byte[] v) {
            this.memberMetadata = v;
            return this;
        }

        public DescribedGroupMember setMemberAssignment(byte[] v) {
            this.memberAssignment = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING, "The member ID assigned by the group coordinator."), new Field("client_id", (Type)Type.STRING, "The client ID used in the member's latest join group request."), new Field("client_host", (Type)Type.STRING, "The client host."), new Field("member_metadata", (Type)Type.BYTES, "The metadata corresponding to the current group protocol in use."), new Field("member_assignment", (Type)Type.BYTES, "The current assignment provided by the group leader.")})));
            SCHEMA_4 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING, "The member ID assigned by the group coordinator."), new Field("group_instance_id", (Type)Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("client_id", (Type)Type.STRING, "The client ID used in the member's latest join group request."), new Field("client_host", (Type)Type.STRING, "The client host."), new Field("member_metadata", (Type)Type.BYTES, "The metadata corresponding to the current group protocol in use."), new Field("member_assignment", (Type)Type.BYTES, "The current assignment provided by the group leader.")});
            SCHEMA_5 = new Schema(new Field[]{new Field("member_id", (Type)Type.COMPACT_STRING, "The member ID assigned by the group coordinator."), new Field("group_instance_id", (Type)Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("client_id", (Type)Type.COMPACT_STRING, "The client ID used in the member's latest join group request."), new Field("client_host", (Type)Type.COMPACT_STRING, "The client host."), new Field("member_metadata", (Type)Type.COMPACT_BYTES, "The metadata corresponding to the current group protocol in use."), new Field("member_assignment", (Type)Type.COMPACT_BYTES, "The current assignment provided by the group leader."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class DescribedGroup
    implements Message {
        short errorCode;
        String groupId;
        String groupState;
        String protocolType;
        String protocolData;
        List<DescribedGroupMember> members;
        int authorizedOperations;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public DescribedGroup(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedGroup(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribedGroup() {
            this.errorCode = 0;
            this.groupId = "";
            this.groupState = "";
            this.protocolType = "";
            this.protocolData = "";
            this.members = new ArrayList<DescribedGroupMember>(0);
            this.authorizedOperations = Integer.MIN_VALUE;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribedGroupMember> newCollection;
            int arrayLength;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroup");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupState had invalid length " + length);
            }
            this.groupState = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field protocolType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field protocolType had invalid length " + length);
            }
            this.protocolType = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field protocolData was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field protocolData had invalid length " + length);
            }
            this.protocolData = _readable.readString(length);
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedGroupMember(_readable, _version));
                }
                this.members = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<DescribedGroupMember>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedGroupMember(_readable, _version));
                }
                this.members = newCollection;
            }
            this.authorizedOperations = _version >= 3 ? _readable.readInt() : Integer.MIN_VALUE;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            Object _stringBytes = _cache.getSerializedValue((Object)this.groupId);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.groupState);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.protocolType);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.protocolData);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.members.size() + 1);
                _stringBytes = this.members.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedGroupMember membersElement = (DescribedGroupMember)_stringBytes.next();
                    membersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.members.size());
                _stringBytes = this.members.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedGroupMember membersElement = (DescribedGroupMember)_stringBytes.next();
                    membersElement.write(_writable, _cache, _version);
                }
            }
            if (_version >= 3) {
                _writable.writeInt(this.authorizedOperations);
            } else if (this.authorizedOperations != Integer.MIN_VALUE) {
                throw new UnsupportedVersionException("Attempted to write a non-default authorizedOperations at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroup");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.groupId = struct.getString("group_id");
            this.groupState = struct.getString("group_state");
            this.protocolType = struct.getString("protocol_type");
            this.protocolData = struct.getString("protocol_data");
            Object[] _nestedObjects = struct.getArray("members");
            this.members = new ArrayList<DescribedGroupMember>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.members.add(new DescribedGroupMember((Struct)nestedObject, _version));
            }
            this.authorizedOperations = _version >= 3 ? struct.getInt("authorized_operations") : Integer.MIN_VALUE;
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribedGroup");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("group_id", (Object)this.groupId);
            struct.set("group_state", (Object)this.groupState);
            struct.set("protocol_type", (Object)this.protocolType);
            struct.set("protocol_data", (Object)this.protocolData);
            Struct[] _nestedObjects = new Struct[this.members.size()];
            int i = 0;
            for (DescribedGroupMember element : this.members) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("members", (Object)_nestedObjects);
            if (_version >= 3) {
                struct.set("authorized_operations", (Object)this.authorizedOperations);
            } else if (this.authorizedOperations != Integer.MIN_VALUE) {
                throw new UnsupportedVersionException("Attempted to write a non-default authorizedOperations at version " + _version);
            }
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedGroup");
            }
            _size += 2;
            byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.groupId, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _stringBytes = this.groupState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.groupState, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'protocolType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.protocolType, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _stringBytes = this.protocolData.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'protocolData' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.protocolData, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.members.size() + 1))) : (_arraySize += 4);
            for (DescribedGroupMember membersElement : this.members) {
                _arraySize += membersElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (_version >= 3) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroup)) {
                return false;
            }
            DescribedGroup other = (DescribedGroup)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.groupState == null ? other.groupState != null : !this.groupState.equals(other.groupState)) {
                return false;
            }
            if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
                return false;
            }
            if (this.protocolData == null ? other.protocolData != null : !this.protocolData.equals(other.protocolData)) {
                return false;
            }
            if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
                return false;
            }
            if (this.authorizedOperations != other.authorizedOperations) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.groupState == null ? 0 : this.groupState.hashCode());
            hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
            hashCode = 31 * hashCode + (this.protocolData == null ? 0 : this.protocolData.hashCode());
            hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
            hashCode = 31 * hashCode + this.authorizedOperations;
            return hashCode;
        }

        public DescribedGroup duplicate() {
            DescribedGroup _duplicate = new DescribedGroup();
            _duplicate.errorCode = this.errorCode;
            _duplicate.groupId = this.groupId;
            _duplicate.groupState = this.groupState;
            _duplicate.protocolType = this.protocolType;
            _duplicate.protocolData = this.protocolData;
            ArrayList<DescribedGroupMember> newMembers = new ArrayList<DescribedGroupMember>(this.members.size());
            for (DescribedGroupMember _element : this.members) {
                newMembers.add(_element.duplicate());
            }
            _duplicate.members = newMembers;
            _duplicate.authorizedOperations = this.authorizedOperations;
            return _duplicate;
        }

        public String toString() {
            return "DescribedGroup(errorCode=" + this.errorCode + ", groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", groupState=" + (this.groupState == null ? "null" : "'" + this.groupState.toString() + "'") + ", protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", protocolData=" + (this.protocolData == null ? "null" : "'" + this.protocolData.toString() + "'") + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ", authorizedOperations=" + this.authorizedOperations + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String groupId() {
            return this.groupId;
        }

        public String groupState() {
            return this.groupState;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public String protocolData() {
            return this.protocolData;
        }

        public List<DescribedGroupMember> members() {
            return this.members;
        }

        public int authorizedOperations() {
            return this.authorizedOperations;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedGroup setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribedGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DescribedGroup setGroupState(String v) {
            this.groupState = v;
            return this;
        }

        public DescribedGroup setProtocolType(String v) {
            this.protocolType = v;
            return this;
        }

        public DescribedGroup setProtocolData(String v) {
            this.protocolData = v;
            return this;
        }

        public DescribedGroup setMembers(List<DescribedGroupMember> v) {
            this.members = v;
            return this;
        }

        public DescribedGroup setAuthorizedOperations(int v) {
            this.authorizedOperations = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The describe error, or 0 if there was no error."), new Field("group_id", (Type)Type.STRING, "The group ID string."), new Field("group_state", (Type)Type.STRING, "The group state string, or the empty string."), new Field("protocol_type", (Type)Type.STRING, "The group protocol type, or the empty string."), new Field("protocol_data", (Type)Type.STRING, "The group protocol data, or the empty string."), new Field("members", (Type)new ArrayOf((Type)DescribedGroupMember.SCHEMA_0), "The group members.")}));
            SCHEMA_3 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The describe error, or 0 if there was no error."), new Field("group_id", (Type)Type.STRING, "The group ID string."), new Field("group_state", (Type)Type.STRING, "The group state string, or the empty string."), new Field("protocol_type", (Type)Type.STRING, "The group protocol type, or the empty string."), new Field("protocol_data", (Type)Type.STRING, "The group protocol data, or the empty string."), new Field("members", (Type)new ArrayOf((Type)DescribedGroupMember.SCHEMA_0), "The group members."), new Field("authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this group.")});
            SCHEMA_4 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The describe error, or 0 if there was no error."), new Field("group_id", (Type)Type.STRING, "The group ID string."), new Field("group_state", (Type)Type.STRING, "The group state string, or the empty string."), new Field("protocol_type", (Type)Type.STRING, "The group protocol type, or the empty string."), new Field("protocol_data", (Type)Type.STRING, "The group protocol data, or the empty string."), new Field("members", (Type)new ArrayOf((Type)DescribedGroupMember.SCHEMA_4), "The group members."), new Field("authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this group.")});
            SCHEMA_5 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The describe error, or 0 if there was no error."), new Field("group_id", (Type)Type.COMPACT_STRING, "The group ID string."), new Field("group_state", (Type)Type.COMPACT_STRING, "The group state string, or the empty string."), new Field("protocol_type", (Type)Type.COMPACT_STRING, "The group protocol type, or the empty string."), new Field("protocol_data", (Type)Type.COMPACT_STRING, "The group protocol data, or the empty string."), new Field("members", (Type)new CompactArrayOf((Type)DescribedGroupMember.SCHEMA_5), "The group members."), new Field("authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this group."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

