/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class BeginQuorumEpochResponseData
implements ApiMessage {
    short errorCode;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top level error code."), new Field("topics", (Type)new ArrayOf((Type)TopicData.SCHEMA_0), "")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public BeginQuorumEpochResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BeginQuorumEpochResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public BeginQuorumEpochResponseData() {
        this.errorCode = 0;
        this.topics = new ArrayList<TopicData>(0);
    }

    public short apiKey() {
        return 53;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        _writable.writeInt(this.topics.size());
        for (TopicData topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TopicData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new TopicData((Struct)nestedObject, _version));
        }
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TopicData element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize += 4;
        for (TopicData topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BeginQuorumEpochResponseData)) {
            return false;
        }
        BeginQuorumEpochResponseData other = (BeginQuorumEpochResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public BeginQuorumEpochResponseData duplicate() {
        BeginQuorumEpochResponseData _duplicate = new BeginQuorumEpochResponseData();
        _duplicate.errorCode = this.errorCode;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "BeginQuorumEpochResponseData(errorCode=" + this.errorCode + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BeginQuorumEpochResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public BeginQuorumEpochResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        short errorCode;
        int leaderId;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, ""), new Field("leader_id", (Type)Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", (Type)Type.INT32, "The latest known leader epoch")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.leaderId = 0;
            this.leaderEpoch = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.leaderId = struct.getInt("leader_id");
            this.leaderEpoch = struct.getInt("leader_epoch");
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("leader_id", (Object)this.leaderId);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size += 4;
            _size += 2;
            _size += 4;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionData setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        String topicName;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)PartitionData.SCHEMA_0), "")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TopicData() {
            this.topicName = "";
            this.partitions = new ArrayList<PartitionData>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topicName);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this._unknownTaggedFields = null;
            this.topicName = struct.getString("topic_name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new PartitionData((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (PartitionData element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (PartitionData partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicName = this.topicName;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

