/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.ssl.SslEngineBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslEngineBuilder {
    private static final Logger log = LoggerFactory.getLogger(NettySslEngineBuilder.class);
    private final SslContext sslContext;

    public static NettySslEngineBuilder maybeCreate(SslEngineBuilder ctx) {
        if (!OpenSsl.isAvailable()) {
            log.warn("Disabling netty because no OpenSSL is available.");
            return null;
        }
        SslContext sslContext = NettySslEngineBuilder.createNettySslContext(ctx);
        return new NettySslEngineBuilder(sslContext);
    }

    private static SslContext createNettySslContext(SslEngineBuilder ctx) {
        try {
            if (ctx.keystore() == null) {
                throw new KafkaException("Whe using netty in server mode, a keystore must be configured.");
            }
            SslEngineBuilder.PrivateKeyData keystorePrivateKeyData = ctx.keystore().loadPrivateKeyData();
            X509Certificate[] truststoreCerts = ctx.truststore() == null ? null : ctx.truststore().loadAllCertificates();
            SslContextBuilder builder = SslContextBuilder.forServer((PrivateKey)keystorePrivateKeyData.key(), (X509Certificate[])keystorePrivateKeyData.certificateChain()).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sslProvider(SslProvider.OPENSSL_REFCNT).trustManager(truststoreCerts);
            if (ctx.enabledProtocols() != null) {
                builder.protocols(ctx.enabledProtocols());
            }
            if (ctx.cipherSuites() != null) {
                builder.ciphers(Arrays.asList(ctx.cipherSuites()));
            }
            switch (ctx.sslClientAuth()) {
                case NONE: {
                    builder.clientAuth(ClientAuth.NONE);
                    break;
                }
                case REQUIRED: {
                    builder.clientAuth(ClientAuth.REQUIRE);
                    break;
                }
                case REQUESTED: {
                    builder.clientAuth(ClientAuth.OPTIONAL);
                }
            }
            log.info("netty is enabled for SSL context with keystore {}, truststore {}.", (Object)ctx.keystore(), (Object)ctx.truststore());
            return builder.build();
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    private NettySslEngineBuilder(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLEngine newEngine(String peerHost, int peerPort) {
        return this.sslContext.newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
    }

    public void closeEngine(SSLEngine e) {
        if (e instanceof ReferenceCountedOpenSslEngine) {
            ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)e;
            engine.release();
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4JLoggerFactory.INSTANCE);
    }
}

