/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.TierListOffsetRequestData;
import org.apache.kafka.common.message.TierListOffsetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.TierListOffsetResponse;

public class TierListOffsetRequest
extends AbstractRequest {
    private final TierListOffsetRequestData data;
    private final short version;

    private TierListOffsetRequest(TierListOffsetRequestData data, short version) {
        super(ApiKeys.TIER_LIST_OFFSET, version);
        this.data = data;
        this.version = version;
    }

    public TierListOffsetRequest(Struct struct, short version) {
        super(ApiKeys.TIER_LIST_OFFSET, version);
        this.data = new TierListOffsetRequestData(struct, version);
        this.version = version;
    }

    public TierListOffsetRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        TierListOffsetResponseData response = new TierListOffsetResponseData();
        ApiError apiError = ApiError.fromThrowable(e);
        for (TierListOffsetRequestData.TierListOffsetTopic topic : this.data.topics()) {
            TierListOffsetResponseData.TierListOffsetTopicResponse topicResponse = new TierListOffsetResponseData.TierListOffsetTopicResponse().setName(topic.name());
            for (TierListOffsetRequestData.TierListOffsetPartition partition : topic.partitions()) {
                topicResponse.partitions().add(new TierListOffsetResponseData.TierListOffsetPartitionResponse().setPartitionIndex(partition.partitionIndex()).setErrorCode(apiError.error().code()));
            }
            response.topics().add(topicResponse);
        }
        return new TierListOffsetResponse(response);
    }

    public static class Builder
    extends AbstractRequest.Builder<TierListOffsetRequest> {
        private final TierListOffsetRequestData data;

        public Builder(TierListOffsetRequestData data) {
            super(ApiKeys.TIER_LIST_OFFSET);
            this.data = data;
        }

        @Override
        public TierListOffsetRequest build(short version) {
            return new TierListOffsetRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }

    public static enum OffsetType {
        LOCAL_START_OFFSET(0),
        LOCAL_END_OFFSET(1);

        private static final Map<Byte, OffsetType> ID_TO_TYPE;
        private byte id;

        private OffsetType(byte id) {
            this.id = id;
        }

        public static OffsetType forId(byte id) {
            if (!OffsetType.hasId(id)) {
                throw new IllegalArgumentException("Unexpected id " + id);
            }
            return ID_TO_TYPE.get(id);
        }

        public static byte toId(OffsetType offsetType) {
            return offsetType.id;
        }

        private static boolean hasId(byte id) {
            return ID_TO_TYPE.containsKey(id);
        }

        static {
            ID_TO_TYPE = new HashMap<Byte, OffsetType>(OffsetType.values().length);
            for (OffsetType offsetType : OffsetType.values()) {
                OffsetType oldValue = ID_TO_TYPE.put(offsetType.id, offsetType);
                if (oldValue == null) continue;
                throw new ExceptionInInitializerError("Duplicate id " + offsetType.id);
            }
        }
    }
}

