/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ReplicaStatusRequestData;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ReplicaStatusResponse;

public class ReplicaStatusRequest
extends AbstractRequest {
    private final ReplicaStatusRequestData data;
    private final short version;

    private ReplicaStatusRequest(ReplicaStatusRequestData data, short version) {
        super(ApiKeys.REPLICA_STATUS, version);
        this.data = data;
        this.version = version;
    }

    public ReplicaStatusRequest(Struct struct, short version) {
        super(ApiKeys.REPLICA_STATUS, version);
        this.data = new ReplicaStatusRequestData(struct, version);
        this.version = version;
    }

    public ReplicaStatusRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable ex) {
        ApiError apiError = ApiError.fromThrowable(ex);
        ReplicaStatusResponseData response = new ReplicaStatusResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(apiError.error().code());
        for (ReplicaStatusRequestData.ReplicaStatusTopic topic : this.data.topics()) {
            ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse = new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName(topic.name());
            for (int partition : topic.partitions()) {
                topicResponse.partitions().add(new ReplicaStatusResponseData.ReplicaStatusPartitionResponse().setPartitionIndex(partition).setErrorCode(apiError.error().code()).setReplicas(null));
            }
            response.topics().add(topicResponse);
        }
        return new ReplicaStatusResponse(response);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReplicaStatusRequest> {
        private final ReplicaStatusRequestData data;

        public Builder(Set<TopicPartition> partitions) {
            super(ApiKeys.REPLICA_STATUS);
            HashMap<String, List> topicToPartitions = new HashMap<String, List>();
            for (TopicPartition partition : partitions) {
                topicToPartitions.computeIfAbsent(partition.topic(), k -> new ArrayList()).add(partition.partition());
            }
            ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic> dataTopics = new ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic>(topicToPartitions.size());
            for (Map.Entry entry : topicToPartitions.entrySet()) {
                dataTopics.add(new ReplicaStatusRequestData.ReplicaStatusTopic().setName((String)entry.getKey()).setPartitions((List)entry.getValue()));
            }
            this.data = new ReplicaStatusRequestData().setTopics(dataTopics);
        }

        @Override
        public ReplicaStatusRequest build(short version) {
            return new ReplicaStatusRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

