/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.provider.DirectoryConfigProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DirectoryConfigProviderTest {
    private DirectoryConfigProvider provider;
    private File parent;
    private File dir;
    private File bar;
    private File foo;
    private File subdir;
    private File subdirFile;
    private File siblingDir;
    private File siblingDirFile;
    private File siblingFile;

    private static File writeFile(File file) throws IOException {
        Files.write(file.toPath(), file.getName().toUpperCase(Locale.ENGLISH).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return file;
    }

    @BeforeEach
    public void setup() throws IOException {
        this.provider = new DirectoryConfigProvider();
        this.provider.configure(Collections.emptyMap());
        this.parent = TestUtils.tempDirectory();
        this.dir = new File(this.parent, "dir");
        this.dir.mkdir();
        this.foo = DirectoryConfigProviderTest.writeFile(new File(this.dir, "foo"));
        this.bar = DirectoryConfigProviderTest.writeFile(new File(this.dir, "bar"));
        this.subdir = new File(this.dir, "subdir");
        this.subdir.mkdir();
        this.subdirFile = DirectoryConfigProviderTest.writeFile(new File(this.subdir, "subdirFile"));
        this.siblingDir = new File(this.parent, "siblingdir");
        this.siblingDir.mkdir();
        this.siblingDirFile = DirectoryConfigProviderTest.writeFile(new File(this.siblingDir, "siblingdirFile"));
        this.siblingFile = DirectoryConfigProviderTest.writeFile(new File(this.parent, "siblingFile"));
    }

    @AfterEach
    public void close() throws IOException {
        this.provider.close();
        Utils.delete((File)this.parent);
    }

    @Test
    public void testGetAllKeysAtPath() {
        ConfigData configData = this.provider.get(this.dir.getAbsolutePath());
        Assertions.assertEquals(TestUtils.toSet(Arrays.asList(this.foo.getName(), this.bar.getName())), configData.data().keySet());
        Assertions.assertEquals((Object)"FOO", configData.data().get(this.foo.getName()));
        Assertions.assertEquals((Object)"BAR", configData.data().get(this.bar.getName()));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testGetSetOfKeysAtPath() {
        Set<String> keys = TestUtils.toSet(Arrays.asList(this.foo.getName(), "baz"));
        ConfigData configData = this.provider.get(this.dir.getAbsolutePath(), keys);
        Assertions.assertEquals(Collections.singleton(this.foo.getName()), configData.data().keySet());
        Assertions.assertEquals((Object)"FOO", configData.data().get(this.foo.getName()));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoSubdirs() {
        Set<String> keys = TestUtils.toSet(Arrays.asList(this.subdir.getName(), String.join((CharSequence)File.separator, this.subdir.getName(), this.subdirFile.getName())));
        ConfigData configData = this.provider.get(this.dir.getAbsolutePath(), keys);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoTraversal() {
        Set<String> keys = TestUtils.toSet(Arrays.asList(String.join((CharSequence)File.separator, "..", this.siblingFile.getName()), String.join((CharSequence)File.separator, "..", this.siblingDir.getName()), String.join((CharSequence)File.separator, "..", this.siblingDir.getName(), this.siblingDirFile.getName())));
        ConfigData configData = this.provider.get(this.dir.getAbsolutePath(), keys);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPath() {
        ConfigData configData = this.provider.get("");
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPathWithKey() {
        ConfigData configData = this.provider.get("", Collections.singleton("foo"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPath() {
        ConfigData configData = this.provider.get(null);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPathWithKey() {
        ConfigData configData = this.provider.get(null, Collections.singleton("foo"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testServiceLoaderDiscovery() {
        ServiceLoader<ConfigProvider> serviceLoader = ServiceLoader.load(ConfigProvider.class);
        Assertions.assertTrue((boolean)StreamSupport.stream(serviceLoader.spliterator(), false).anyMatch(configProvider -> configProvider instanceof DirectoryConfigProvider));
    }
}

