/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.mock.TestProviderCreator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class SslFactoryTest {
    private final String tlsProtocol;

    public SslFactoryTest(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)engine);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.tlsProtocol}), (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assertions.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslFactoryWithCustomKeyManagerConfiguration() {
        TestProviderCreator testProviderCreator = new TestProviderCreator();
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", testProviderCreator.getClass().getName());
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assertions.assertNotNull((Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not created");
        Security.removeProvider(testProviderCreator.getProvider().getName());
    }

    @Test
    public void testSslFactoryWithoutProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        Assertions.assertThrows(KafkaException.class, () -> sslFactory.configure(serverSslConfig));
    }

    @Test
    public void testSslFactoryWithIncorrectProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", "com.fake.ProviderClass1,com.fake.ProviderClass2");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        Assertions.assertThrows(KafkaException.class, () -> sslFactory.configure(serverSslConfig));
    }

    @Test
    public void testSslFactoryWithoutPasswordConfiguration() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        serverSslConfig.remove("ssl.truststore.password");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        try {
            sslFactory.configure(serverSslConfig);
        }
        catch (Exception e) {
            Assertions.fail((String)("An exception was thrown when configuring the truststore without a password: " + e));
        }
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertTrue((boolean)engine.getUseClientMode());
    }

    @Test
    public void staleSslEngineFactoryShouldBeClosed() throws IOException, GeneralSecurityException {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory sslEngineFactory = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assertions.assertNotNull((Object)sslEngineFactory);
        Assertions.assertFalse((boolean)sslEngineFactory.closed);
        trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        clientSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        sslFactory.reconfigure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory newSslEngineFactory = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assertions.assertNotEquals((Object)sslEngineFactory, (Object)newSslEngineFactory);
        Assertions.assertTrue((boolean)sslEngineFactory.closed);
    }

    @Test
    public void testReconfiguration() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SslEngineFactory sslEngineFactory = sslFactory.sslEngineFactory();
        Assertions.assertNotNull((Object)sslEngineFactory, (String)"SslEngineFactory not created");
        sslFactory.reconfigure(sslConfig);
        Assertions.assertSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory recreated unnecessarily");
        trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslFactory.reconfigure(sslConfig);
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        trustStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        File keyStoreFile = new File((String)sslConfig.get("ssl.keystore.location"));
        keyStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 15000L);
        sslFactory.validateReconfiguration(sslConfig);
        sslFactory.reconfigure(sslConfig);
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 20000L);
        Files.delete(keyStoreFile.toPath());
        sslFactory.reconfigure(sslConfig);
        Assertions.assertSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory recreated unnecessarily");
    }

    @Test
    public void testReconfigurationWithoutTruststore() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.truststore.location");
        sslConfig.remove("ssl.truststore.password");
        sslConfig.remove("ssl.truststore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = ((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext();
        Assertions.assertNotNull((Object)sslContext, (String)"SSL context not created");
        Assertions.assertSame((Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext(), (String)"SSL context recreated unnecessarily");
        Assertions.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assertions.fail((String)"Truststore configured dynamically for listener without previous truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testReconfigurationWithoutKeystore() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = ((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext();
        Assertions.assertNotNull((Object)sslContext, (String)"SSL context not created");
        Assertions.assertSame((Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext(), (String)"SSL context recreated unnecessarily");
        Assertions.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        File newTrustStoreFile = TestUtils.tempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        sslFactory.reconfigure(sslConfig);
        Assertions.assertNotSame((Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext(), (String)"SSL context not recreated");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig);
            Assertions.fail((String)"Keystore configured dynamically for listener without previous keystore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testPemReconfiguration() throws Exception {
        Properties props = new Properties();
        props.putAll(this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(null).usePem(true).build());
        TestSecurityConfig sslConfig = new TestSecurityConfig(props);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig.values());
        SslEngineFactory sslEngineFactory = sslFactory.sslEngineFactory();
        Assertions.assertNotNull((Object)sslEngineFactory, (String)"SslEngineFactory not created");
        props.put("some.config", "some.value");
        sslConfig = new TestSecurityConfig(props);
        sslFactory.reconfigure(sslConfig.values());
        Assertions.assertSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory recreated unnecessarily");
        props.put("ssl.keystore.key", new Password(((Password)props.get("ssl.keystore.key")).value() + " "));
        sslConfig = new TestSecurityConfig(props);
        sslFactory.reconfigure(sslConfig.values());
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        props.put("ssl.keystore.certificate.chain", new Password(((Password)props.get("ssl.keystore.certificate.chain")).value() + " "));
        sslConfig = new TestSecurityConfig(props);
        sslFactory.reconfigure(sslConfig.values());
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
        props.put("ssl.truststore.certificates", new Password(((Password)props.get("ssl.truststore.certificates")).value() + " "));
        sslConfig = new TestSecurityConfig(props);
        sslFactory.reconfigure(sslConfig.values());
        Assertions.assertNotSame((Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not recreated");
        sslEngineFactory = sslFactory.sslEngineFactory();
    }

    @Test
    public void testKeyStoreTrustStoreValidation() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assertions.assertNotNull((Object)sslFactory.sslEngineFactory(), (String)"SslEngineFactory not created");
    }

    @Test
    public void testUntrustedKeyStoreValidationFails() throws Exception {
        File trustStoreFile1 = TestUtils.tempFile("truststore1", ".jks");
        File trustStoreFile2 = TestUtils.tempFile("truststore2", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).build();
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        for (String key : Arrays.asList("ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.trustmanager.algorithm")) {
            sslConfig1.put(key, sslConfig2.get(key));
        }
        try {
            sslFactory.configure(sslConfig1);
            Assertions.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeystoreVerifiableUsingTruststore() throws Exception {
        this.verifyKeystoreVerifiableUsingTruststore(false, this.tlsProtocol);
    }

    @Test
    public void testPemKeystoreVerifiableUsingTruststore() throws Exception {
        this.verifyKeystoreVerifiableUsingTruststore(true, this.tlsProtocol);
    }

    private void verifyKeystoreVerifiableUsingTruststore(boolean usePem, String tlsProtocol) throws Exception {
        File trustStoreFile1 = usePem ? null : File.createTempFile("truststore1", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).usePem(usePem).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        sslFactory.configure(sslConfig1);
        File trustStoreFile2 = usePem ? null : File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).usePem(usePem).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assertions.fail((String)"ValidateReconfiguration did not fail as expected");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testCertificateEntriesValidation() throws Exception {
        this.verifyCertificateEntriesValidation(false, this.tlsProtocol);
    }

    @Test
    public void testPemCertificateEntriesValidation() throws Exception {
        this.verifyCertificateEntriesValidation(true, this.tlsProtocol);
    }

    private void verifyCertificateEntriesValidation(boolean usePem, String tlsProtocol) throws Exception {
        File trustStoreFile = usePem ? null : TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).usePem(usePem).build();
        File newTrustStoreFile = usePem ? null : TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> newCnConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).cn("Another CN").usePem(usePem).build();
        KeyStore ks1 = this.sslKeyStore(serverSslConfig);
        KeyStore ks2 = this.sslKeyStore(serverSslConfig);
        Assertions.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        ks2.setCertificateEntry("another", ks1.getCertificate("localhost"));
        Assertions.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        KeyStore ks3 = this.sslKeyStore(newCnConfig);
        Assertions.assertNotEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks3));
    }

    @Test
    public void testClientSpecifiedSslEngineFactoryUsed() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        Assertions.assertTrue((boolean)(sslFactory.sslEngineFactory() instanceof TestSslUtils.TestSslEngineFactory), (String)"SslEngineFactory must be of expected type");
    }

    @Test
    public void testEngineFactoryClosed() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory engine = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assertions.assertFalse((boolean)engine.closed);
        sslFactory.close();
        Assertions.assertTrue((boolean)engine.closed);
    }

    @Test
    public void testServerSpecifiedSslEngineFactoryUsed() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        serverSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assertions.assertTrue((boolean)(sslFactory.sslEngineFactory() instanceof TestSslUtils.TestSslEngineFactory), (String)"SslEngineFactory must be of expected type");
    }

    @Test
    public void testInvalidSslEngineFactory() throws Exception {
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", String.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        Assertions.assertThrows(ClassCastException.class, () -> sslFactory.configure(clientSslConfig));
    }

    @Test
    public void testUsedConfigs() throws IOException, GeneralSecurityException {
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(TestUtils.tempFile("truststore", ".jks")).useClientCert(false).build();
        serverSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        TestSecurityConfig securityConfig = new TestSecurityConfig(serverSslConfig);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(securityConfig.values());
        Assertions.assertFalse((boolean)securityConfig.unused().contains("ssl.engine.factory.class"));
    }

    private KeyStore sslKeyStore(Map<String, Object> sslConfig) {
        Object store = sslConfig.get("ssl.keystore.location") != null ? new DefaultSslEngineFactory.FileBasedStore((String)sslConfig.get("ssl.keystore.type"), (String)sslConfig.get("ssl.keystore.location"), (Password)sslConfig.get("ssl.keystore.password"), (Password)sslConfig.get("ssl.key.password"), true) : new DefaultSslEngineFactory.PemStore((Password)sslConfig.get("ssl.keystore.certificate.chain"), (Password)sslConfig.get("ssl.keystore.key"), (Password)sslConfig.get("ssl.key.password"));
        return store.get();
    }

    private TestSslUtils.SslConfigsBuilder sslConfigsBuilder(Mode mode) {
        return new TestSslUtils.SslConfigsBuilder(mode).tlsProtocol(this.tlsProtocol);
    }
}

