/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.Record;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlRecordUtilsTest {
    @Test
    public void testCurrentVersions() {
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
        Assertions.assertEquals((short)0, (short)0);
    }

    @Test
    public void testInvalidControlRecordType() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDeserializeRecord(ControlRecordType.COMMIT));
        Assertions.assertEquals((Object)"Expected LEADER_CHANGE control record type(2), but found COMMIT", (Object)thrown.getMessage());
    }

    @Test
    public void testDeserializeByteData() {
        this.testDeserializeRecord(ControlRecordType.LEADER_CHANGE);
    }

    private void testDeserializeRecord(ControlRecordType controlRecordType) {
        boolean leaderId = true;
        int voterId = 2;
        LeaderChangeMessage data = new LeaderChangeMessage().setLeaderId(1).setVoters(Collections.singletonList(new LeaderChangeMessage.Voter().setVoterId(2)));
        ByteBuffer valueBuffer = ByteBuffer.allocate(256);
        data.write((Writable)new ByteBufferAccessor(valueBuffer), new ObjectSerializationCache(), data.highestSupportedVersion());
        valueBuffer.flip();
        byte[] keyData = new byte[]{0, 0, 0, (byte)controlRecordType.type};
        DefaultRecord record = new DefaultRecord(256, 0, 0L, 0L, 0, ByteBuffer.wrap(keyData), valueBuffer, null);
        LeaderChangeMessage deserializedData = ControlRecordUtils.deserializeLeaderChangeMessage((Record)record);
        Assertions.assertEquals((int)1, (int)deserializedData.leaderId());
        Assertions.assertEquals(Collections.singletonList(new LeaderChangeMessage.Voter().setVoterId(2)), deserializedData.voters());
    }
}

