/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class RateTest {
    private static final double EPS = 1.0E-6;
    private Rate r;
    private Time timeClock;

    @BeforeEach
    public void setup() {
        this.r = new Rate();
        this.timeClock = new MockTime();
    }

    @ParameterizedTest
    @CsvSource(value={"1,1", "1,11", "11,1", "11,11"})
    public void testRateWithNoPriorAvailableSamples(int numSample, int sampleWindowSizeSec) {
        MetricConfig config = new MetricConfig().samples(numSample).timeWindow((long)sampleWindowSizeSec, TimeUnit.SECONDS);
        double sampleValue = 50.0;
        this.r.record(config, 50.0, this.timeClock.milliseconds());
        long measurementTime = TimeUnit.SECONDS.toMillis(sampleWindowSizeSec) - 1L;
        this.timeClock.sleep(measurementTime);
        double observedRate = this.r.measure(config, this.timeClock.milliseconds());
        Assertions.assertFalse((boolean)Double.isNaN(observedRate));
        int dummyPriorSamplesAssumedByAlgorithm = numSample - 1;
        double windowSize = MetricsUtils.convert((long)measurementTime, (TimeUnit)TimeUnit.SECONDS) + (double)(dummyPriorSamplesAssumedByAlgorithm * sampleWindowSizeSec);
        double expectedRatePerSec = 50.0 / windowSize;
        Assertions.assertEquals((double)expectedRatePerSec, (double)observedRate, (double)1.0E-6);
    }
}

