/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.utils.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class StickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new StickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscription(List<String> topics, List<TopicPartition> partitions) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(-1))));
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionWithGeneration(List<String> topics, List<TopicPartition> partitions, int generation) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generation))));
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithEqualPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(this.consumer1, this.buildSubscription(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 1))));
        this.subscriptions.put(this.consumer2, this.buildSubscription(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 2))));
        this.subscriptions.put(this.consumer3, this.buildSubscription(StickyAssignorTest.topics(this.topic), Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithUnequalPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 4);
        this.subscriptions.put(this.consumer1, this.buildSubscription(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 1))));
        this.subscriptions.put(this.consumer2, this.buildSubscription(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 2))));
        this.subscriptions.put(this.consumer3, this.buildSubscription(StickyAssignorTest.topics(this.topic), Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 1), StickyAssignorTest.tp(this.topic, 3)), assignment.get(this.consumer1));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="testAssignmentWithMultipleGenerations1 with isAllSubscriptionsEqual: {0}")
    @ValueSource(booleans={true, false})
    public void testAssignmentWithMultipleGenerations1(boolean isAllSubscriptionsEqual) {
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2);
        List<String> consumer2SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 6);
        partitionsPerTopic.put(this.topic2, 6);
        this.subscriptions.put(this.consumer1, new ConsumerPartitionAssignor.Subscription(allTopics));
        this.subscriptions.put(this.consumer2, new ConsumerPartitionAssignor.Subscription(consumer2SubscribedTopics));
        this.subscriptions.put(this.consumer3, new ConsumerPartitionAssignor.Subscription(allTopics));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(this.consumer1);
        List r1partitions2 = (List)assignment.get(this.consumer2);
        List r1partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r1partitions1.size() == 4 && r1partitions2.size() == 4 && r1partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscription(allTopics, r1partitions1));
        this.subscriptions.put(this.consumer2, this.buildSubscription(consumer2SubscribedTopics, r1partitions2));
        this.subscriptions.remove(this.consumer3);
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r2partitions1 = (List)assignment.get(this.consumer1);
        List r2partitions2 = (List)assignment.get(this.consumer2);
        Assertions.assertTrue((r2partitions1.size() == 6 && r2partitions2.size() == 6 ? 1 : 0) != 0);
        if (isAllSubscriptionsEqual) {
            Assertions.assertTrue((boolean)r2partitions1.containsAll(r1partitions1));
        }
        Assertions.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assertions.assertFalse((boolean)Collections.disjoint(r2partitions2, r1partitions3));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionWithGeneration(consumer2SubscribedTopics, r2partitions2, 2));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionWithGeneration(allTopics, r1partitions3, 1));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r3partitions2 = (List)assignment.get(this.consumer2);
        List r3partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r3partitions2.size() == 6 && r3partitions3.size() == 6 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Collections.disjoint(r3partitions2, r3partitions3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="testAssignmentWithMultipleGenerations2 with isAllSubscriptionsEqual: {0}")
    @ValueSource(booleans={true, false})
    public void testAssignmentWithMultipleGenerations2(boolean isAllSubscriptionsEqual) {
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2, this.topic3);
        List<String> consumer1SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        List<String> consumer3SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic, this.topic2);
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 4);
        partitionsPerTopic.put(this.topic2, 4);
        partitionsPerTopic.put(this.topic3, 4);
        this.subscriptions.put(this.consumer1, new ConsumerPartitionAssignor.Subscription(consumer1SubscribedTopics));
        this.subscriptions.put(this.consumer2, new ConsumerPartitionAssignor.Subscription(allTopics));
        this.subscriptions.put(this.consumer3, new ConsumerPartitionAssignor.Subscription(consumer3SubscribedTopics));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(this.consumer1);
        List r1partitions2 = (List)assignment.get(this.consumer2);
        List r1partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r1partitions1.size() == 4 && r1partitions2.size() == 4 && r1partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionWithGeneration(allTopics, r1partitions2, 1));
        this.subscriptions.remove(this.consumer3);
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r2partitions2 = (List)assignment.get(this.consumer2);
        Assertions.assertEquals((int)12, (int)r2partitions2.size());
        Assertions.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionWithGeneration(consumer1SubscribedTopics, r1partitions1, 1));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionWithGeneration(allTopics, r2partitions2, 2));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionWithGeneration(consumer3SubscribedTopics, r1partitions3, 1));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List r3partitions1 = (List)assignment.get(this.consumer1);
        List r3partitions2 = (List)assignment.get(this.consumer2);
        List r3partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r3partitions1.size() == 4 && r3partitions2.size() == 4 && r3partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="testAssignmentWithConflictingPreviousGenerations with isAllSubscriptionsEqual: {0}")
    @ValueSource(booleans={true, false})
    public void testAssignmentWithConflictingPreviousGenerations(boolean isAllSubscriptionsEqual) {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 4);
        partitionsPerTopic.put(this.topic2, 4);
        partitionsPerTopic.put(this.topic3, 4);
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2, this.topic3);
        List<String> consumer1SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        List<String> consumer2SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic, this.topic2);
        this.subscriptions.put(this.consumer1, new ConsumerPartitionAssignor.Subscription(consumer1SubscribedTopics));
        this.subscriptions.put(this.consumer2, new ConsumerPartitionAssignor.Subscription(consumer2SubscribedTopics));
        this.subscriptions.put(this.consumer3, new ConsumerPartitionAssignor.Subscription(allTopics));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        TopicPartition tp3 = new TopicPartition(this.topic, 3);
        TopicPartition t2p0 = new TopicPartition(this.topic2, 0);
        TopicPartition t2p1 = new TopicPartition(this.topic2, 1);
        TopicPartition t2p2 = new TopicPartition(this.topic2, 2);
        TopicPartition t2p3 = new TopicPartition(this.topic2, 3);
        TopicPartition t3p0 = new TopicPartition(this.topic3, 0);
        TopicPartition t3p1 = new TopicPartition(this.topic3, 1);
        TopicPartition t3p2 = new TopicPartition(this.topic3, 2);
        TopicPartition t3p3 = new TopicPartition(this.topic3, 3);
        List<TopicPartition> c1partitions0 = isAllSubscriptionsEqual ? StickyAssignorTest.partitions(tp0, tp1, tp2, t2p2, t2p3, t3p0) : StickyAssignorTest.partitions(tp0, tp1, tp2, tp3);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp0, tp1, t2p0, t2p1, t2p2, t2p3);
        List<TopicPartition> c3partitions0 = StickyAssignorTest.partitions(tp2, tp3, t3p0, t3p1, t3p2, t3p3);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionWithGeneration(consumer1SubscribedTopics, c1partitions0, 1));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionWithGeneration(consumer2SubscribedTopics, c2partitions0, 2));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionWithGeneration(allTopics, c3partitions0, 2));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(this.consumer1);
        List c2partitions = (List)assignment.get(this.consumer2);
        List c3partitions = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((c1partitions.size() == 4 && c2partitions.size() == 4 && c3partitions.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        Assertions.assertTrue((boolean)c3partitions0.containsAll(c3partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testSchemaBackwardCompatibility() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(this.consumer1, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(this.consumer2, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(this.consumer3, new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic)));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        List<TopicPartition> c1partitions0 = StickyAssignorTest.partitions(tp0, tp2);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp1);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionWithGeneration(StickyAssignorTest.topics(this.topic), c1partitions0, 1));
        this.subscriptions.put(this.consumer2, StickyAssignorTest.buildSubscriptionWithOldSchema(StickyAssignorTest.topics(this.topic), c2partitions0));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(this.consumer1);
        List c2partitions = (List)assignment.get(this.consumer2);
        List c3partitions = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((c1partitions.size() == 1 && c2partitions.size() == 1 && c3partitions.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)c1partitions0.containsAll(c1partitions));
        Assertions.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    private static ConsumerPartitionAssignor.Subscription buildSubscriptionWithOldSchema(List<String> topics, List<TopicPartition> partitions) {
        Struct struct = new Struct(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0);
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry topicEntry : CollectionUtils.groupPartitionsByTopic(partitions).entrySet()) {
            Struct topicAssignment = new Struct(StickyAssignor.TOPIC_ASSIGNMENT);
            topicAssignment.set("topic", topicEntry.getKey());
            topicAssignment.set("partitions", (Object)((List)topicEntry.getValue()).toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set("previous_assignment", (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.sizeOf((Object)struct));
        StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.write(buffer, (Object)struct);
        buffer.flip();
        return new ConsumerPartitionAssignor.Subscription(topics, buffer);
    }
}

