/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.secured.Retry;
import org.apache.kafka.common.security.oauthbearer.secured.Retryable;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RetryTest
extends OAuthBearerTest {
    @Test
    public void test() throws ExecutionException {
        Exception[] attempts = new Exception[]{new IOException("pretend connect error"), new IOException("pretend timeout error"), new IOException("pretend read error"), null};
        long retryWaitMs = 1000L;
        long maxWaitMs = 10000L;
        Retryable<String> call = this.createRetryable(attempts);
        MockTime time = new MockTime(0L, 0L, 0L);
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Retry r = new Retry((Time)time, retryWaitMs, maxWaitMs);
        r.execute(call);
        long secondWait = retryWaitMs * 2L;
        long thirdWait = retryWaitMs * 4L;
        long totalWait = retryWaitMs + secondWait + thirdWait;
        Assertions.assertEquals((long)totalWait, (long)time.milliseconds());
    }

    @Test
    public void testIOExceptionFailure() {
        Exception[] attempts = new Exception[]{new IOException("pretend connect error"), new IOException("pretend timeout error"), new IOException("pretend read error"), new IOException("pretend another read error")};
        long retryWaitMs = 1000L;
        long maxWaitMs = 6999L;
        Retryable<String> call = this.createRetryable(attempts);
        MockTime time = new MockTime(0L, 0L, 0L);
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Retry r = new Retry((Time)time, retryWaitMs, maxWaitMs);
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)r.execute(call);
        });
        Assertions.assertEquals((long)maxWaitMs, (long)time.milliseconds());
    }

    @Test
    public void testRuntimeExceptionFailureOnLastAttempt() {
        Exception[] attempts = new Exception[]{new IOException("pretend connect error"), new IOException("pretend timeout error"), new NullPointerException("pretend JSON node /userId in response is null")};
        long retryWaitMs = 1000L;
        long maxWaitMs = 10000L;
        Retryable<String> call = this.createRetryable(attempts);
        MockTime time = new MockTime(0L, 0L, 0L);
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Retry r = new Retry((Time)time, retryWaitMs, maxWaitMs);
        Assertions.assertThrows(RuntimeException.class, () -> {
            String cfr_ignored_0 = (String)r.execute(call);
        });
        long secondWait = retryWaitMs * 2L;
        long totalWait = retryWaitMs + secondWait;
        Assertions.assertEquals((long)totalWait, (long)time.milliseconds());
    }

    @Test
    public void testRuntimeExceptionFailureOnFirstAttempt() {
        Exception[] attempts = new Exception[]{new NullPointerException("pretend JSON node /userId in response is null"), null};
        long retryWaitMs = 1000L;
        long maxWaitMs = 10000L;
        Retryable<String> call = this.createRetryable(attempts);
        MockTime time = new MockTime(0L, 0L, 0L);
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Retry r = new Retry((Time)time, retryWaitMs, maxWaitMs);
        Assertions.assertThrows(RuntimeException.class, () -> {
            String cfr_ignored_0 = (String)r.execute(call);
        });
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
    }

    @Test
    public void testUseMaxTimeout() throws IOException {
        Exception[] attempts = new Exception[]{new IOException("pretend connect error"), new IOException("pretend timeout error"), new IOException("pretend read error")};
        long retryWaitMs = 5000L;
        long maxWaitMs = 5000L;
        Retryable<String> call = this.createRetryable(attempts);
        MockTime time = new MockTime(0L, 0L, 0L);
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Retry r = new Retry((Time)time, retryWaitMs, maxWaitMs);
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)r.execute(call);
        });
        Assertions.assertEquals((long)maxWaitMs, (long)time.milliseconds());
    }
}

