/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = body -> true;
    private int correlation;
    private Runnable wakeupHook;
    private final Time time;
    private final MockMetadataUpdater metadataUpdater;
    private final Map<String, ConnectionState> connections = new HashMap<String, ConnectionState>();
    private final Map<Node, Long> pendingAuthenticationErrors = new HashMap<Node, Long>();
    private final Map<Node, AuthenticationException> authenticationErrors = new HashMap<Node, AuthenticationException>();
    private final Queue<ClientRequest> requests = new ConcurrentLinkedDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ConcurrentLinkedDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ConcurrentLinkedDeque<FutureResponse>();
    private final Queue<MetadataUpdate> metadataUpdates = new ConcurrentLinkedDeque<MetadataUpdate>();
    private volatile NodeApiVersions nodeApiVersions = NodeApiVersions.create();
    private volatile int numBlockingWakeups = 0;
    private volatile boolean active = true;

    public MockClient(Time time, Metadata metadata) {
        this(time, new DefaultMockMetadataUpdater(metadata));
    }

    public MockClient(Time time, MockMetadataUpdater metadataUpdater) {
        this.time = time;
        this.metadataUpdater = metadataUpdater;
    }

    public boolean isConnected(String idString) {
        return this.connectionState(idString).state == ConnectionState.State.CONNECTED;
    }

    private ConnectionState connectionState(String idString) {
        ConnectionState connectionState = this.connections.get(idString);
        if (connectionState == null) {
            connectionState = new ConnectionState();
            this.connections.put(idString, connectionState);
        }
        return connectionState;
    }

    public boolean isReady(Node node, long now) {
        return this.connectionState(node.idString()).isReady(now);
    }

    public boolean ready(Node node, long now) {
        return this.connectionState(node.idString()).ready(now);
    }

    public long connectionDelay(Node node, long now) {
        return this.connectionState(node.idString()).connectionDelay(now);
    }

    public long pollDelayMs(Node node, long now) {
        return this.connectionDelay(node, now);
    }

    public void backoff(Node node, long durationMs) {
        this.connectionState(node.idString()).backoff(this.time.milliseconds() + durationMs);
    }

    public void setUnreachable(Node node, long durationMs) {
        this.disconnect(node.idString());
        this.connectionState(node.idString()).setUnreachable(this.time.milliseconds() + durationMs);
    }

    public void throttle(Node node, long durationMs) {
        this.connectionState(node.idString()).throttle(this.time.milliseconds() + durationMs);
    }

    public void delayReady(Node node, long durationMs) {
        this.connectionState(node.idString()).setReadyDelayed(this.time.milliseconds() + durationMs);
    }

    public void authenticationFailed(Node node, long backoffMs) {
        this.pendingAuthenticationErrors.remove(node);
        this.authenticationErrors.put(node, (AuthenticationException)Errors.SASL_AUTHENTICATION_FAILED.exception());
        this.disconnect(node.idString());
        this.backoff(node, backoffMs);
    }

    public void createPendingAuthenticationError(Node node, long backoffMs) {
        this.pendingAuthenticationErrors.put(node, backoffMs);
    }

    public boolean connectionFailed(Node node) {
        return this.connectionState(node.idString()).isBackingOff(this.time.milliseconds());
    }

    public AuthenticationException authenticationException(Node node) {
        return this.authenticationErrors.get(node);
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.destination().equals(node)) continue;
            short version = request.requestBuilder().latestAllowedVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, null, null));
            iter.remove();
        }
        this.connectionState(node).disconnect();
    }

    public void send(ClientRequest request, long now) {
        if (!this.connectionState(request.destination()).isReady(now)) {
            throw new IllegalStateException("Cannot send " + request + " since the destination is not ready");
        }
        Iterator<Map.Entry<Node, Long>> authErrorIter = this.pendingAuthenticationErrors.entrySet().iterator();
        while (authErrorIter.hasNext()) {
            Map.Entry<Node, Long> entry = authErrorIter.next();
            Node node = entry.getKey();
            long backoffMs = entry.getValue();
            if (!node.idString().equals(request.destination())) continue;
            authErrorIter.remove();
            this.authenticationFailed(node, backoffMs);
            AbstractRequest.Builder builder = request.requestBuilder();
            short version = this.nodeApiVersions.latestUsableVersion(request.apiKey(), builder.oldestAllowedVersion(), builder.latestAllowedVersion());
            ClientResponse resp = new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), true, null, new AuthenticationException("Authentication failed"), null);
            this.responses.add(resp);
            return;
        }
        Iterator iterator = this.futureResponses.iterator();
        while (iterator.hasNext()) {
            FutureResponse futureResp = (FutureResponse)iterator.next();
            if (futureResp.node != null && !request.destination().equals(futureResp.node.idString())) continue;
            AbstractRequest.Builder builder = request.requestBuilder();
            short version = this.nodeApiVersions.latestUsableVersion(request.apiKey(), builder.oldestAllowedVersion(), builder.latestAllowedVersion());
            UnsupportedVersionException unsupportedVersionException = null;
            if (futureResp.isUnsupportedRequest) {
                unsupportedVersionException = new UnsupportedVersionException("Api " + request.apiKey() + " with version " + version);
            } else {
                AbstractRequest abstractRequest = request.requestBuilder().build(version);
                if (!futureResp.requestMatcher.matches(abstractRequest)) {
                    throw new IllegalStateException("Request matcher did not match next-in-line request " + abstractRequest + " with prepared response " + futureResp.responseBody);
                }
            }
            ClientResponse resp = new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), futureResp.disconnected, unsupportedVersionException, null, futureResp.responseBody);
            this.responses.add(resp);
            iterator.remove();
            return;
        }
        this.requests.add(request);
    }

    public synchronized void enableBlockingUntilWakeup(int numBlockingWakeups) {
        this.numBlockingWakeups = numBlockingWakeups;
    }

    public synchronized void wakeup() {
        if (this.numBlockingWakeups > 0) {
            --this.numBlockingWakeups;
            this.notify();
        }
        if (this.wakeupHook != null) {
            this.wakeupHook.run();
        }
    }

    private synchronized void maybeAwaitWakeup() {
        try {
            int remainingBlockingWakeups = this.numBlockingWakeups;
            if (remainingBlockingWakeups <= 0) {
                return;
            }
            while (this.numBlockingWakeups == remainingBlockingWakeups) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ClientResponse response;
        this.maybeAwaitWakeup();
        this.checkTimeoutOfPendingRequests(now);
        if (this.metadataUpdater.isUpdateNeeded() && this.leastLoadedNode(now) != null) {
            MetadataUpdate metadataUpdate = this.metadataUpdates.poll();
            if (metadataUpdate != null) {
                this.metadataUpdater.update(this.time, metadataUpdate);
            } else {
                this.metadataUpdater.updateWithCurrentMetadata(this.time);
            }
        }
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>();
        while ((response = this.responses.poll()) != null) {
            response.onComplete();
            copy.add(response);
        }
        return copy;
    }

    private long elapsedTimeMs(long currentTimeMs, long startTimeMs) {
        return Math.max(0L, currentTimeMs - startTimeMs);
    }

    private void checkTimeoutOfPendingRequests(long nowMs) {
        ClientRequest request = this.requests.peek();
        while (request != null && this.elapsedTimeMs(nowMs, request.createdTimeMs()) > (long)request.requestTimeoutMs()) {
            this.disconnect(request.destination());
            this.requests.poll();
            request = this.requests.peek();
        }
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public Queue<ClientResponse> responses() {
        return this.responses;
    }

    public Queue<FutureResponse> futureResponses() {
        return this.futureResponses;
    }

    public void respond(AbstractResponse response) {
        this.respond(response, false);
    }

    public void respond(RequestMatcher matcher, AbstractResponse response) {
        ClientRequest nextRequest = this.requests.peek();
        if (nextRequest == null) {
            throw new IllegalStateException("No current requests queued");
        }
        AbstractRequest request = nextRequest.requestBuilder().build();
        if (!matcher.matches(request)) {
            throw new IllegalStateException("Request matcher did not match next-in-line request " + request);
        }
        this.respond(response);
    }

    public void respondToRequest(ClientRequest clientRequest, AbstractResponse response) {
        this.requests.remove(clientRequest);
        short version = clientRequest.requestBuilder().latestAllowedVersion();
        this.responses.add(new ClientResponse(clientRequest.makeHeader(version), clientRequest.callback(), clientRequest.destination(), clientRequest.createdTimeMs(), this.time.milliseconds(), false, null, null, response));
    }

    public void respond(AbstractResponse response, boolean disconnected) {
        if (this.requests.isEmpty()) {
            throw new IllegalStateException("No requests pending for inbound response " + response);
        }
        ClientRequest request = this.requests.poll();
        short version = request.requestBuilder().latestAllowedVersion();
        this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, null, response));
    }

    public void respondFrom(AbstractResponse response, Node node) {
        this.respondFrom(response, node, false);
    }

    public void respondFrom(AbstractResponse response, Node node, boolean disconnected) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ClientRequest request = (ClientRequest)iterator.next();
            if (!request.destination().equals(node.idString())) continue;
            iterator.remove();
            short version = request.requestBuilder().latestAllowedVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, null, response));
            return;
        }
        throw new IllegalArgumentException("No requests available to node " + node);
    }

    public void prepareResponse(AbstractResponse response) {
        this.prepareResponse(ALWAYS_TRUE, response, false);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, false, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response) {
        this.prepareResponse(matcher, response, false);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node) {
        this.prepareResponseFrom(matcher, response, node, false, false);
    }

    public void prepareResponse(AbstractResponse response, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, response, disconnected);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node, boolean disconnected) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, disconnected, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response, boolean disconnected) {
        this.prepareResponseFrom(matcher, response, null, disconnected, false);
    }

    public void prepareUnsupportedVersionResponse(RequestMatcher matcher) {
        this.prepareResponseFrom(matcher, null, null, false, true);
    }

    private void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node, boolean disconnected, boolean isUnsupportedVersion) {
        this.futureResponses.add(new FutureResponse(node, matcher, response, disconnected, isUnsupportedVersion));
    }

    public void waitForRequests(final int minRequests, long maxWaitMs) throws InterruptedException {
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return MockClient.this.requests.size() >= minRequests;
            }
        }, maxWaitMs, "Expected requests have not been sent");
    }

    public void reset() {
        this.connections.clear();
        this.requests.clear();
        this.responses.clear();
        this.futureResponses.clear();
        this.metadataUpdates.clear();
        this.authenticationErrors.clear();
    }

    public boolean hasPendingMetadataUpdates() {
        return !this.metadataUpdates.isEmpty();
    }

    public int numAwaitingResponses() {
        return this.futureResponses.size();
    }

    public void prepareMetadataUpdate(MetadataResponse updateResponse) {
        this.prepareMetadataUpdate(updateResponse, false);
    }

    public void prepareMetadataUpdate(MetadataResponse updateResponse, boolean expectMatchMetadataTopics) {
        this.metadataUpdates.add(new MetadataUpdate(updateResponse, expectMatchMetadataTopics));
    }

    public void updateMetadata(MetadataResponse updateResponse) {
        this.metadataUpdater.update(this.time, new MetadataUpdate(updateResponse, false));
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public boolean hasInFlightRequests() {
        return !this.requests.isEmpty();
    }

    public boolean hasPendingResponses() {
        return !this.responses.isEmpty() || !this.futureResponses.isEmpty();
    }

    public int inFlightRequestCount(String node) {
        int result = 0;
        for (ClientRequest req : this.requests) {
            if (!req.destination().equals(node)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasInFlightRequests(String node) {
        return this.inFlightRequestCount(node) > 0;
    }

    public boolean hasReadyNodes(long now) {
        return this.connections.values().stream().anyMatch(cxn -> cxn.isReady(now));
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse) {
        return this.newClientRequest(nodeId, requestBuilder, createdTimeMs, expectResponse, 5000, null);
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse, int requestTimeoutMs, RequestCompletionHandler callback) {
        return new ClientRequest(nodeId, requestBuilder, this.correlation++, "mockClientId", createdTimeMs, expectResponse, requestTimeoutMs, callback);
    }

    public void initiateClose() {
        this.close();
    }

    public boolean active() {
        return this.active;
    }

    public void close() {
        this.active = false;
        this.metadataUpdater.close();
    }

    public void close(String node) {
        this.connections.remove(node);
    }

    public Node leastLoadedNode(long now) {
        for (Node node : this.metadataUpdater.fetchNodes()) {
            if (this.connectionState(node.idString()).isBackingOff(now)) continue;
            return node;
        }
        return null;
    }

    public void setWakeupHook(Runnable wakeupHook) {
        this.wakeupHook = wakeupHook;
    }

    public void setNodeApiVersions(NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions = nodeApiVersions;
    }

    private static class ConnectionState {
        private long throttledUntilMs = 0L;
        private long readyDelayedUntilMs = 0L;
        private long backingOffUntilMs = 0L;
        private long unreachableUntilMs = 0L;
        private State state = State.DISCONNECTED;

        private ConnectionState() {
        }

        void backoff(long untilMs) {
            this.backingOffUntilMs = untilMs;
        }

        void throttle(long untilMs) {
            this.throttledUntilMs = untilMs;
        }

        void setUnreachable(long untilMs) {
            this.unreachableUntilMs = untilMs;
        }

        void setReadyDelayed(long untilMs) {
            this.readyDelayedUntilMs = untilMs;
        }

        boolean isReady(long now) {
            return this.state == State.CONNECTED && this.notThrottled(now);
        }

        boolean isReadyDelayed(long now) {
            return now < this.readyDelayedUntilMs;
        }

        boolean notThrottled(long now) {
            return now > this.throttledUntilMs;
        }

        boolean isBackingOff(long now) {
            return now < this.backingOffUntilMs;
        }

        boolean isUnreachable(long now) {
            return now < this.unreachableUntilMs;
        }

        void disconnect() {
            this.state = State.DISCONNECTED;
        }

        long connectionDelay(long now) {
            if (this.state != State.DISCONNECTED) {
                return Long.MAX_VALUE;
            }
            if (this.backingOffUntilMs > now) {
                return this.backingOffUntilMs - now;
            }
            return 0L;
        }

        boolean ready(long now) {
            switch (this.state) {
                case CONNECTED: {
                    return this.notThrottled(now);
                }
                case CONNECTING: {
                    if (this.isReadyDelayed(now)) {
                        return false;
                    }
                    this.state = State.CONNECTED;
                    return this.ready(now);
                }
                case DISCONNECTED: {
                    if (this.isBackingOff(now)) {
                        return false;
                    }
                    if (this.isUnreachable(now)) {
                        this.backingOffUntilMs = now + 100L;
                        return false;
                    }
                    this.state = State.CONNECTING;
                    return this.ready(now);
                }
            }
            throw new IllegalArgumentException("Invalid state: " + (Object)((Object)this.state));
        }

        static enum State {
            CONNECTING,
            CONNECTED,
            DISCONNECTED;

        }
    }

    private static class DefaultMockMetadataUpdater
    implements MockMetadataUpdater {
        private final Metadata metadata;
        private MetadataUpdate lastUpdate;

        public DefaultMockMetadataUpdater(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public List<Node> fetchNodes() {
            return this.metadata.fetch().nodes();
        }

        @Override
        public boolean isUpdateNeeded() {
            return this.metadata.updateRequested();
        }

        @Override
        public void updateWithCurrentMetadata(Time time) {
            if (this.lastUpdate == null) {
                throw new IllegalStateException("No previous metadata update to use");
            }
            this.update(time, this.lastUpdate);
        }

        private void maybeCheckExpectedTopics(MetadataUpdate update, MetadataRequest.Builder builder) {
            if (update.expectMatchRefreshTopics) {
                if (builder.isAllTopics()) {
                    throw new IllegalStateException("The metadata topics does not match expectation. Expected topics: " + update.topics() + ", asked topics: ALL");
                }
                HashSet requestedTopics = new HashSet(builder.topics());
                if (!requestedTopics.equals(update.topics())) {
                    throw new IllegalStateException("The metadata topics does not match expectation. Expected topics: " + update.topics() + ", asked topics: " + requestedTopics);
                }
            }
        }

        @Override
        public void update(Time time, MetadataUpdate update) {
            MetadataRequest.Builder builder = this.metadata.newMetadataRequestBuilder();
            this.maybeCheckExpectedTopics(update, builder);
            this.metadata.updateWithCurrentRequestVersion(update.updateResponse, false, time.milliseconds());
            this.lastUpdate = update;
        }

        @Override
        public void close() {
            this.metadata.close();
        }
    }

    public static interface MockMetadataUpdater {
        public List<Node> fetchNodes();

        public boolean isUpdateNeeded();

        public void update(Time var1, MetadataUpdate var2);

        default public void updateWithCurrentMetadata(Time time) {
        }

        default public void close() {
        }
    }

    public static class MetadataUpdate {
        final MetadataResponse updateResponse;
        final boolean expectMatchRefreshTopics;

        MetadataUpdate(MetadataResponse updateResponse, boolean expectMatchRefreshTopics) {
            this.updateResponse = updateResponse;
            this.expectMatchRefreshTopics = expectMatchRefreshTopics;
        }

        private Set<String> topics() {
            return this.updateResponse.topicMetadata().stream().map(MetadataResponse.TopicMetadata::topic).collect(Collectors.toSet());
        }
    }

    @FunctionalInterface
    public static interface RequestMatcher {
        public boolean matches(AbstractRequest var1);
    }

    private static class FutureResponse {
        private final Node node;
        private final RequestMatcher requestMatcher;
        private final AbstractResponse responseBody;
        private final boolean disconnected;
        private final boolean isUnsupportedRequest;

        public FutureResponse(Node node, RequestMatcher requestMatcher, AbstractResponse responseBody, boolean disconnected, boolean isUnsupportedRequest) {
            this.node = node;
            this.requestMatcher = requestMatcher;
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.isUnsupportedRequest = isUnsupportedRequest;
        }
    }
}

