/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.gui.XMLConfPanel;
import org.apache.jmeter.extractor.XPathExtractor;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="xpath_extractor_title")
public class XPathExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 240L;
    private final JLabeledTextField defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
    private final JLabeledTextField xpathQueryField = new JLabeledTextField(JMeterUtils.getResString((String)"xpath_extractor_query"));
    private final JLabeledTextField matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
    private final JLabeledTextField refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
    private final JCheckBox getFragment = new JCheckBox(JMeterUtils.getResString((String)"xpath_extractor_fragment"));
    private final XMLConfPanel xml = new XMLConfPanel();

    public String getLabelResource() {
        return "xpath_extractor_title";
    }

    public XPathExtractorGui() {
        this.init();
    }

    public void configure(TestElement el) {
        super.configure(el);
        XPathExtractor xpe = (XPathExtractor)el;
        this.showScopeSettings(xpe, true);
        this.xpathQueryField.setText(xpe.getXPathQuery());
        this.defaultField.setText(xpe.getDefaultValue());
        this.refNameField.setText(xpe.getRefName());
        this.matchNumberField.setText(xpe.getMatchNumberAsString());
        this.getFragment.setSelected(xpe.getFragment());
        this.xml.configure(xpe);
    }

    public TestElement createTestElement() {
        XPathExtractor extractor = new XPathExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof XPathExtractor) {
            XPathExtractor xpath = (XPathExtractor)extractor;
            this.saveScopeSettings(xpath);
            xpath.setDefaultValue(this.defaultField.getText());
            xpath.setRefName(this.refNameField.getText());
            xpath.setMatchNumber(this.matchNumberField.getText());
            xpath.setXPathQuery(this.xpathQueryField.getText());
            xpath.setFragment(this.getFragment.isSelected());
            this.xml.modifyTestElement(xpath);
        }
    }

    public void clearGui() {
        super.clearGui();
        this.xpathQueryField.setText("");
        this.defaultField.setText("");
        this.refNameField.setText("");
        this.matchNumberField.setText(XPathExtractor.DEFAULT_VALUE_AS_STRING);
        this.xml.setDefaultValues();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true, true, true));
        this.xml.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"xpath_assertion_option")));
        box.add(this.xml);
        box.add(this.getFragment);
        box.add(this.makeParameterPanel());
        this.add(box, "North");
    }

    private JPanel makeParameterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        XPathExtractorGui.initConstraints(gbc);
        XPathExtractorGui.addField(panel, this.refNameField, gbc);
        XPathExtractorGui.resetContraints(gbc);
        XPathExtractorGui.addField(panel, this.xpathQueryField, gbc);
        XPathExtractorGui.resetContraints(gbc);
        XPathExtractorGui.addField(panel, this.matchNumberField, gbc);
        XPathExtractorGui.resetContraints(gbc);
        gbc.weighty = 1.0;
        XPathExtractorGui.addField(panel, this.defaultField, gbc);
        return panel;
    }

    private static void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private static void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private static void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

