/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.apachehc.ApacheHCUtils;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;

public class ApacheHCHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpUriRequest> {
    private final HttpClient client;
    private final ApacheHCUtils apacheHCUtils;
    private final String userAgent;

    @Inject
    ApacheHCHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, HttpClient client, @Named(value="jclouds.idempotent-methods") String idempotentMethods, @Named(value="jclouds.user-agent") String userAgent) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, idempotentMethods);
        this.client = client;
        this.apacheHCUtils = new ApacheHCUtils(contentMetadataCodec);
        this.userAgent = userAgent;
    }

    protected HttpUriRequest convert(HttpRequest request) throws IOException {
        HttpUriRequest returnVal = this.apacheHCUtils.convertToApacheRequest(request);
        if (request.getPayload() != null && request.getPayload().getContentMetadata().getContentMD5() != null) {
            String md5 = BaseEncoding.base64().encode(request.getPayload().getContentMetadata().getContentMD5AsHashCode().asBytes());
            returnVal.addHeader("Content-MD5", md5);
        }
        if (!returnVal.containsHeader("User-Agent")) {
            returnVal.addHeader("User-Agent", this.userAgent);
        }
        return returnVal;
    }

    /*
     * Unable to fully structure code
     */
    protected HttpResponse invoke(HttpUriRequest nativeRequest) throws IOException {
        apacheResponse = this.executeRequest(nativeRequest);
        payload = null;
        if (apacheResponse.getEntity() != null) {
            try {
                payload = Payloads.newInputStreamPayload((InputStream)apacheResponse.getEntity().getContent());
                if (apacheResponse.getEntity().getContentLength() >= 0L) {
                    payload.getContentMetadata().setContentLength(Long.valueOf(apacheResponse.getEntity().getContentLength()));
                }
                if (apacheResponse.getEntity().getContentType() == null) ** GOTO lbl15
                payload.getContentMetadata().setContentType(apacheResponse.getEntity().getContentType().getValue());
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "couldn't receive payload for request: %s", new Object[]{nativeRequest.getRequestLine()});
                throw e;
            }
        } else {
            payload = Payloads.newStringPayload((String)"");
        }
lbl15:
        // 3 sources

        headers = LinkedHashMultimap.create();
        for (Header header : apacheResponse.getAllHeaders()) {
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap)headers);
        headers = HttpUtils.filterOutContentHeaders((Multimap)headers);
        return ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(apacheResponse.getStatusLine().getStatusCode()).message(apacheResponse.getStatusLine().getReasonPhrase()).payload((Payload)payload)).headers((Multimap)headers)).build();
    }

    private org.apache.http.HttpResponse executeRequest(HttpUriRequest nativeRequest) throws IOException, ClientProtocolException {
        URI endpoint = URI.create(nativeRequest.getRequestLine().getUri());
        HttpHost host = new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme());
        org.apache.http.HttpResponse nativeResponse = this.client.execute(host, (org.apache.http.HttpRequest)nativeRequest);
        return nativeResponse;
    }

    protected void cleanup(HttpUriRequest nativeResponse) {
    }
}

