/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.impl.LocalNameMapper;
import org.apache.jackrabbit.oak.namepath.impl.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class TargetImportHandler
extends DefaultHandler {
    protected final Importer importer;
    protected final SessionContext sessionContext;
    private final ListMultimap<String, String> documentContext = ArrayListMultimap.create();
    private Map<String, String> documentPrefixMap = Collections.emptyMap();

    protected TargetImportHandler(Importer importer, SessionContext sessionContext) {
        this.importer = importer;
        this.sessionContext = sessionContext;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.documentContext.put((Object)prefix, (Object)uri);
        this.documentPrefixMap = this.createCurrentPrefixMap();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        List uris = this.documentContext.get((Object)prefix);
        if (!uris.isEmpty()) {
            uris.remove(uris.size() - 1);
        }
        this.documentPrefixMap = this.createCurrentPrefixMap();
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.importer.start();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.importer.end();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public NamePathMapper currentNamePathMapper() {
        return new NamePathMapperImpl((NameMapper)new LocalNameMapper(this.sessionContext.getSessionDelegate().getRoot(), this.documentPrefixMap));
    }

    private Map<String, String> createCurrentPrefixMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set entries = this.documentContext.asMap().entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            result.put(key, (String)value.get(value.size() - 1));
        }
        return result;
    }

    protected class NameInfo {
        private final String localName;
        private final String docPrefix;
        private String namespaceUri;
        private String repoPrefix;

        NameInfo(String docQualifiedName) throws RepositoryException {
            int idx = docQualifiedName.indexOf(58);
            if (idx == -1) {
                this.docPrefix = null;
                this.localName = docQualifiedName;
            } else {
                String[] splits = docQualifiedName.split(":", 2);
                this.docPrefix = splits[0];
                this.localName = splits[1];
            }
            this.init();
        }

        NameInfo(String docPrefix, String localName) throws RepositoryException {
            this.localName = localName;
            this.docPrefix = docPrefix;
            this.init();
        }

        private void init() throws RepositoryException {
            if (this.docPrefix == null) {
                this.namespaceUri = "";
                this.repoPrefix = null;
            } else {
                List uris = TargetImportHandler.this.documentContext.get((Object)this.docPrefix);
                Tree tree = TargetImportHandler.this.sessionContext.getSessionDelegate().getRoot().getTree("/");
                if (uris.isEmpty()) {
                    this.namespaceUri = Namespaces.getNamespaceURI((Tree)tree, (String)this.docPrefix);
                    this.repoPrefix = this.docPrefix;
                } else {
                    this.namespaceUri = (String)uris.get(uris.size() - 1);
                    this.repoPrefix = Namespaces.getNamespacePrefix((Tree)tree, (String)this.namespaceUri);
                }
            }
        }

        String getLocalName() {
            return this.localName;
        }

        String getNamespaceUri() {
            return this.namespaceUri;
        }

        String getDocPrefix() {
            return this.docPrefix;
        }

        String getRepoQualifiedName() {
            if (this.repoPrefix == null || this.repoPrefix.isEmpty()) {
                return this.localName;
            }
            return this.repoPrefix + ':' + this.localName;
        }
    }
}

