/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStoreUtils;
import org.apache.jackrabbit.oak.plugins.blob.datastore.AbstractDataStoreTest;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.internal.matchers.Equals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestS3Ds
extends AbstractDataStoreTest {
    protected static final Logger LOG = LoggerFactory.getLogger(TestS3Ds.class);
    private Date startTime = null;
    protected Properties props;
    protected String bucket;
    @Parameterized.Parameter
    public String s3Class;

    @Parameterized.Parameters(name="{index}: ({0})")
    public static List<String> fixtures() {
        return S3DataStoreUtils.getFixtures();
    }

    @BeforeClass
    public static void assumptions() {
        Assume.assumeTrue((boolean)S3DataStoreUtils.isS3Configured());
    }

    @Before
    public void setUp() throws Exception {
        this.props = S3DataStoreUtils.getS3Config();
        this.startTime = new Date();
        this.bucket = String.valueOf(this.randomGen.nextInt(9999)) + "-" + String.valueOf(this.randomGen.nextInt(9999)) + "-test";
        this.props.setProperty("s3Bucket", this.bucket);
        this.props.setProperty("secret", "123456");
        super.setUp();
    }

    @After
    public void tearDown() {
        try {
            super.tearDown();
            S3DataStoreUtils.deleteBucket(this.bucket, this.startTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected DataStore createDataStore() throws RepositoryException {
        DataStore s3ds = null;
        try {
            s3ds = S3DataStoreUtils.getS3DataStore(this.s3Class, this.props, this.dataStoreDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sleep(1000L);
        return s3ds;
    }

    public void testUpdateLastModifiedOnAccess() {
        Assume.assumeThat((Object)this.s3Class, (Matcher)new Equals((Object)TestS3Ds.fixtures().get(1)));
        super.testUpdateLastModifiedOnAccess();
    }

    public void testDeleteAllOlderThan() {
        Assume.assumeThat((Object)this.s3Class, (Matcher)new Equals((Object)TestS3Ds.fixtures().get(1)));
        super.testDeleteAllOlderThan();
    }
}

