/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Hex;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStoreUtils;
import org.apache.jackrabbit.oak.blob.cloud.s3.TestS3Ds;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestS3DataStore {
    protected static final Logger LOG = LoggerFactory.getLogger(TestS3Ds.class);
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    private Properties props;
    @Parameterized.Parameter
    public String s3Class;
    private File dataStoreDir;
    private DataStore ds;

    @Parameterized.Parameters(name="{index}: ({0})")
    public static List<String> fixtures() {
        return S3DataStoreUtils.getFixtures();
    }

    @Before
    public void setUp() throws Exception {
        this.dataStoreDir = this.folder.newFolder();
        this.props = new Properties();
    }

    @Test
    public void testAccessParamLeakOnError() throws Exception {
        this.expectedEx.expect(RepositoryException.class);
        this.expectedEx.expectMessage("Could not initialize S3 from {s3Region=us-standard}");
        this.props.put("accessKey", "abcd");
        this.props.put("secretKey", "123456");
        this.props.put("s3Region", "us-standard");
        this.ds = S3DataStoreUtils.getS3DataStore(this.s3Class, this.props, this.dataStoreDir.getAbsolutePath());
    }

    @Test
    public void testNoSecretDefined() throws Exception {
        Assume.assumeTrue((boolean)S3DataStoreUtils.isS3Configured());
        Assume.assumeTrue((boolean)this.s3Class.equals(S3DataStoreUtils.JR2_S3.getName()));
        Random randomGen = new Random();
        this.props = S3DataStoreUtils.getS3Config();
        this.ds = S3DataStoreUtils.getS3DataStore(this.s3Class, this.props, this.dataStoreDir.getAbsolutePath());
        byte[] data = new byte[4096];
        randomGen.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        Assert.assertEquals((long)data.length, (long)rec.getLength());
        Assert.assertNull((Object)rec.getReference());
    }

    @Test
    public void testNoSecretDefinedUseDefault() throws Exception {
        Assume.assumeTrue((boolean)S3DataStoreUtils.isS3Configured());
        Assume.assumeTrue((boolean)this.s3Class.equals(S3DataStoreUtils.S3.getName()));
        Random randomGen = new Random();
        this.props = S3DataStoreUtils.getS3Config();
        this.ds = S3DataStoreUtils.getS3DataStore(this.s3Class, this.props, this.dataStoreDir.getAbsolutePath());
        byte[] data = new byte[4096];
        randomGen.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        Assert.assertEquals((long)data.length, (long)rec.getLength());
        Assert.assertNotNull((Object)rec.getReference());
    }

    @Test
    public void testSecretDefined() throws Exception {
        Assume.assumeTrue((boolean)S3DataStoreUtils.isS3Configured());
        Random randomGen = new Random();
        this.props = S3DataStoreUtils.getS3Config();
        this.props.setProperty("secret", "123456");
        this.ds = S3DataStoreUtils.getS3DataStore(this.s3Class, this.props, this.dataStoreDir.getAbsolutePath());
        byte[] data = new byte[4096];
        randomGen.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        Assert.assertEquals((long)data.length, (long)rec.getLength());
        String ref = rec.getReference();
        Assert.assertNotNull((Object)ref);
        String id = rec.getIdentifier().toString();
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec("123456".getBytes("UTF-8"), "HmacSHA1"));
        byte[] hash = mac.doFinal(id.getBytes("UTF-8"));
        id = id + ':' + Hex.encodeHexString((byte[])hash);
        Assert.assertEquals((Object)id, (Object)ref);
    }
}

