/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.blob.cloud.s3.TestS3Ds;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestS3DSWithSSES3
extends TestS3Ds {
    protected static final Logger LOG = LoggerFactory.getLogger(TestS3DSWithSSES3.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.props.setProperty("s3Encryption", "SSE_S3");
        this.props.setProperty("cacheSize", "0");
    }

    @Test
    public void testDataMigration() {
        try {
            this.ds.close();
            this.props.remove("s3Encryption");
            this.ds = this.createDataStore();
            byte[] data = new byte[this.dataLength];
            this.randomGen.nextBytes(data);
            DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
            Assert.assertEquals((long)data.length, (long)rec.getLength());
            this.assertRecord(data, rec);
            this.ds.close();
            this.props.setProperty("s3Encryption", "SSE_S3");
            this.props.setProperty("s3RenameKeys", "true");
            this.ds = this.createDataStore();
            rec = this.ds.getRecord(rec.getIdentifier());
            Assert.assertEquals((long)data.length, (long)rec.getLength());
            this.assertRecord(data, rec);
            this.randomGen.nextBytes(data);
            this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
            this.ds.close();
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }
}

