/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.SharedS3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.Utils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DataStoreUtils
extends DataStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(S3DataStoreUtils.class);
    private static final String DEFAULT_CONFIG_PATH = "./src/test/resources/aws.properties";
    protected static Class JR2_S3 = SharedS3DataStore.class;
    protected static Class S3 = S3DataStore.class;

    public static List<String> getFixtures() {
        return ImmutableList.of((Object)S3.getName(), (Object)JR2_S3.getName());
    }

    public static boolean isS3DataStore() {
        boolean s3Class;
        String dsName = System.getProperty("dataStore");
        boolean bl = s3Class = dsName != null && (dsName.equals(S3.getName()) || dsName.equals(JR2_S3.getName()));
        if (!S3DataStoreUtils.isS3Configured()) {
            return false;
        }
        return s3Class;
    }

    public static boolean isS3Configured() {
        Properties props = S3DataStoreUtils.getS3Config();
        return props.containsKey("accessKey") && props.containsKey("secretKey") && (props.containsKey("s3Region") || props.containsKey("s3EndPoint"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getS3Config() {
        String config = System.getProperty("config");
        if (Strings.isNullOrEmpty((String)config)) {
            config = DEFAULT_CONFIG_PATH;
        }
        Properties props = new Properties();
        if (new File(config).exists()) {
            InputStream is = null;
            try {
                props.load(new FileInputStream(config));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(is);
            }
            props.putAll((Map<?, ?>)S3DataStoreUtils.getConfig());
            Map filtered = Maps.filterEntries((Map)Maps.fromProperties((Properties)props), (Predicate)new Predicate<Map.Entry<? extends Object, ? extends Object>>(){

                public boolean apply(Map.Entry<? extends Object, ? extends Object> input) {
                    return !Strings.isNullOrEmpty((String)((String)input.getValue()));
                }
            });
            props = new Properties();
            props.putAll((Map<?, ?>)filtered);
        }
        return props;
    }

    public static DataStore getS3DataStore(String className, Properties props, String homeDir) throws Exception {
        DataStore ds = Class.forName(className).asSubclass(DataStore.class).newInstance();
        PropertiesUtil.populate((Object)ds, (Map)Maps.fromProperties((Properties)props), (boolean)false);
        if (S3.getName().equals(className)) {
            ((S3DataStore)ds).setProperties(props);
        } else if (JR2_S3.getName().equals(className)) {
            ((SharedS3DataStore)ds).setProperties(props);
        }
        ds.init(homeDir);
        return ds;
    }

    public static DataStore getS3DataStore(String className, String homeDir) throws Exception {
        return S3DataStoreUtils.getS3DataStore(className, S3DataStoreUtils.getS3Config(), homeDir);
    }

    public static void deleteBucket(String bucket, Date date) throws Exception {
        log.info("cleaning bucket [" + bucket + "]");
        Properties props = S3DataStoreUtils.getS3Config();
        AmazonS3Client s3service = Utils.openService((Properties)props);
        TransferManager tmx = new TransferManager((AmazonS3)s3service);
        if (s3service.doesBucketExist(bucket)) {
            block0: for (int i = 0; i < 4; ++i) {
                tmx.abortMultipartUploads(bucket, date);
                ObjectListing prevObjectListing = s3service.listObjects(bucket);
                while (prevObjectListing != null) {
                    ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
                    for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                        deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
                    }
                    if (deleteList.size() > 0) {
                        DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(bucket);
                        delObjsReq.setKeys(deleteList);
                        s3service.deleteObjects(delObjsReq);
                    }
                    if (!prevObjectListing.isTruncated()) continue block0;
                    prevObjectListing = s3service.listNextBatchOfObjects(prevObjectListing);
                }
            }
            s3service.deleteBucket(bucket);
            log.info("bucket [ " + bucket + "] cleaned");
        } else {
            log.info("bucket [" + bucket + "] doesn't exists");
        }
        tmx.shutdownNow();
        s3service.shutdown();
    }
}

