/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.SharedS3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStoreService;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStoreUtils;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class S3DataStoreServiceTest {
    @Rule
    public OsgiContext context = new OsgiContext();
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    private S3DataStoreService service;

    @BeforeClass
    public static void assumptions() {
        Assume.assumeTrue((boolean)S3DataStoreUtils.isS3Configured());
    }

    @Before
    public void setUp() {
        this.context.registerService(StatisticsProvider.class, (Object)StatisticsProvider.NOOP);
    }

    @After
    public void tear() {
        System.clearProperty("oak.datastore.jr2caching");
    }

    @Test
    public void testDefaultS3Implementation() throws IOException {
        this.registerBlobStore();
        Assert.assertNotNull((Object)this.context.getService(AbstractSharedCachingDataStore.class));
        this.unregisterBlobStore();
    }

    @Test
    public void testJR2Caching() throws IOException {
        System.setProperty("oak.datastore.jr2caching", "true");
        this.registerBlobStore();
        Assert.assertNotNull((Object)this.context.getService(SharedS3DataStore.class));
        this.unregisterBlobStore();
    }

    private void registerBlobStore() throws IOException {
        HashMap properties = Maps.newHashMap();
        properties.putAll(Maps.fromProperties((Properties)S3DataStoreUtils.getS3Config()));
        properties.put("repository.home", this.folder.newFolder().getAbsolutePath());
        this.service = (S3DataStoreService)this.context.registerInjectActivateService((Object)new S3DataStoreService(), (Map)properties);
    }

    private void unregisterBlobStore() {
        MockOsgi.deactivate((Object)this.service);
    }
}

