/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.aws.s3;

import com.google.common.collect.Lists;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.S3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStoreUtils;
import org.apache.jackrabbit.oak.blob.cloud.s3.TestS3Ds;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestS3DSAsyncTouch
extends TestS3Ds {
    protected static final Logger LOG = LoggerFactory.getLogger(TestS3DSAsyncTouch.class);

    @Parameterized.Parameters(name="{index}: ({0})")
    public static List<String> fixtures() {
        return Lists.newArrayList((Object[])new String[]{S3DataStoreUtils.getFixtures().get(1)});
    }

    protected CachingDataStore createDataStore() throws RepositoryException {
        S3DataStore s3ds = new S3DataStore();
        s3ds.setProperties(this.props);
        s3ds.setSecret("123456");
        s3ds.setTouchAsync(true);
        s3ds.setAsyncUploadLimit(0);
        s3ds.init(this.dataStoreDir);
        s3ds.updateModifiedDateOnAccess(System.currentTimeMillis() + 50000L);
        this.sleep(1000L);
        return s3ds;
    }
}

