/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.aws.s3;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jackrabbit.core.data.AsyncTouchCallback;
import org.apache.jackrabbit.core.data.AsyncTouchResult;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.AsyncUploadResult;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.S3DataStoreStats;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.SharedS3DataStore;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class S3DataStoreStatsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    private static NodeStore nodeStore;
    private static Blob mockBlob;
    private static String testNodePathName;
    private File testFile;
    private SharedS3DataStore defaultS3ds;
    private SharedS3DataStore autoSyncMockS3ds;
    private SharedS3DataStore manualSyncMockS3ds;
    private S3DataStoreStats stats;

    @Before
    public void setup() throws Exception {
        this.testFile = this.folder.newFile();
        FileUtils.copyInputStreamToFile((InputStream)S3DataStoreStatsTest.randomStream(0, 16384), (File)this.testFile);
        String testNodeId = this.getIdForInputStream(new FileInputStream(this.testFile));
        mockBlob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)mockBlob.getContentIdentity()).thenReturn((Object)testNodeId);
        nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.absent());
        this.defaultS3ds = (SharedS3DataStore)Mockito.mock(SharedS3DataStore.class);
        this.autoSyncMockS3ds = new CustomBackendS3DataStore(new TestMemoryBackend());
        this.autoSyncMockS3ds.init(this.folder.newFolder().getAbsolutePath());
        this.manualSyncMockS3ds = new CustomBackendS3DataStore(new ManuallySyncingInMemoryBackend());
        this.manualSyncMockS3ds.init(this.folder.newFolder().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIdForInputStream(InputStream in) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        DigestOutputStream output = new DigestOutputStream((OutputStream)new NullOutputStream(), digest);
        try {
            IOUtils.copyLarge((InputStream)in, (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((InputStream)in);
        }
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private static NodeStore initNodeStore(Optional<Blob> blobProp1, Optional<Blob> blobProp2, Optional<String> stringProp, Optional<Integer> intProp, Optional<List<Blob>> blobPropList) throws CommitFailedException {
        MemoryNodeStore nodeStore = new MemoryNodeStore();
        NodeBuilder rootBuilder = nodeStore.getRoot().builder();
        NodeBuilder builder = S3DataStoreStatsTest.initNodeBuilder(rootBuilder);
        if (blobProp1.isPresent()) {
            builder.setProperty("blobProp1", blobProp1.get());
        }
        if (blobProp2.isPresent()) {
            builder.setProperty("blobProp2", blobProp2.get());
        }
        if (stringProp.isPresent()) {
            builder.setProperty("stringProp", stringProp.get());
        }
        if (intProp.isPresent()) {
            builder.setProperty("intProp", intProp.get());
        }
        if (blobPropList.isPresent()) {
            builder.setProperty(MultiBinaryPropertyState.binaryPropertyFromBlob((String)"blobPropList", (Iterable)((Iterable)blobPropList.get())));
        }
        nodeStore.merge(rootBuilder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        return nodeStore;
    }

    private static NodeBuilder initNodeBuilder(NodeBuilder rootBuilder) {
        NodeBuilder builder = rootBuilder;
        for (String nodeName : PathUtils.elements((String)testNodePathName)) {
            builder = builder.child(nodeName);
        }
        return builder;
    }

    @After
    public void teardown() throws Exception {
    }

    @Test
    public void testGetActiveS3FileSyncMetricExists() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.defaultS3ds;
        Assert.assertTrue((0L == this.stats.getActiveSyncs() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSingleActiveS3FileSyncMetric() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.manualSyncMockS3ds;
        DataRecord record = null;
        try {
            record = this.manualSyncMockS3ds.addRecord(S3DataStoreStatsTest.getStream("test"));
            Assert.assertTrue((1L == this.stats.getActiveSyncs() ? 1 : 0) != 0);
        }
        finally {
            if (null != record) {
                this.manualSyncMockS3ds.deleteRecord(record.getIdentifier());
            }
        }
        ((ManuallySyncingInMemoryBackend)this.manualSyncMockS3ds.getBackend()).clearInProgressWrites();
        Assert.assertTrue((0L == this.stats.getActiveSyncs() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMultilpleActiveS3FileSyncMetric() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.manualSyncMockS3ds;
        HashSet records = Sets.newHashSet();
        try {
            records.add(this.manualSyncMockS3ds.addRecord(S3DataStoreStatsTest.getStream("test1")));
            records.add(this.manualSyncMockS3ds.addRecord(S3DataStoreStatsTest.getStream("test2")));
            records.add(this.manualSyncMockS3ds.addRecord(S3DataStoreStatsTest.getStream("test3")));
            Assert.assertTrue((3L == this.stats.getActiveSyncs() ? 1 : 0) != 0);
        }
        finally {
            for (DataRecord record : records) {
                this.manualSyncMockS3ds.deleteRecord(record.getIdentifier());
            }
        }
        ((ManuallySyncingInMemoryBackend)this.manualSyncMockS3ds.getBackend()).clearInProgressWrites();
        Assert.assertTrue((0L == this.stats.getActiveSyncs() ? 1 : 0) != 0);
    }

    @Test
    public void testIsFileSyncedMetricExists() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.defaultS3ds;
        Assert.assertFalse((boolean)this.stats.isFileSynced(testNodePathName));
    }

    @Test
    public void testIsFileSyncedNullFileReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.defaultS3ds;
        Assert.assertFalse((boolean)this.stats.isFileSynced(null));
    }

    @Test
    public void testIsFileSyncedEmptyStringReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.defaultS3ds;
        Assert.assertFalse((boolean)this.stats.isFileSynced(""));
    }

    @Test
    public void testIsFileSyncedInvalidFilenameReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.defaultS3ds;
        Assert.assertFalse((boolean)this.stats.isFileSynced("invalid"));
    }

    @Test
    public void testIsFileSyncedFileNotAddedReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        Assert.assertFalse((boolean)this.stats.isFileSynced(testNodePathName));
    }

    @Test
    public void testIsFileSyncedSyncIncompleteReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.manualSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.manualSyncMockS3ds, new FileInputStream(this.testFile));
    }

    @Test
    public void testIsFileSyncedSyncCompleteReturnsTrue() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedTrue(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsFileSyncedFileDeletedReturnsFalse() throws Exception {
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        DataRecord record = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.testFile);
            record = this.autoSyncMockS3ds.addRecord((InputStream)stream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            S3DataStoreStatsTest.delete(this.autoSyncMockS3ds, Lists.newArrayList((Object[])new DataRecord[]{record}));
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        S3DataStoreStatsTest.delete(this.autoSyncMockS3ds, Lists.newArrayList((Object[])new DataRecord[]{record}));
        Assert.assertFalse((boolean)this.stats.isFileSynced(testNodePathName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsFileSyncedDifferentPaths() throws Exception {
        String path1 = "path/to/node/1";
        String path2 = "path/to/node/2";
        String path3 = "shortpath";
        String path4 = "a/very/very/long/path/leads/to/node/4";
        ArrayList paths = Lists.newArrayList((Object[])new String[]{"path/to/node/1", "path/to/node/2", "shortpath", "a/very/very/long/path/leads/to/node/4"});
        String leadingSlashPath = "/path/to/node/1";
        ArrayList blobContents = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"});
        ArrayList blobs = Lists.newArrayList((Object[])new Blob[]{(Blob)Mockito.mock(Blob.class), (Blob)Mockito.mock(Blob.class), (Blob)Mockito.mock(Blob.class), (Blob)Mockito.mock(Blob.class)});
        ArrayList blobIds = Lists.newArrayList((Object[])new String[]{this.getIdForInputStream(S3DataStoreStatsTest.getStream((String)blobContents.get(0))), this.getIdForInputStream(S3DataStoreStatsTest.getStream((String)blobContents.get(1))), this.getIdForInputStream(S3DataStoreStatsTest.getStream((String)blobContents.get(2))), this.getIdForInputStream(S3DataStoreStatsTest.getStream((String)blobContents.get(3)))});
        Mockito.when((Object)((Blob)blobs.get(0)).getContentIdentity()).thenReturn(blobIds.get(0));
        Mockito.when((Object)((Blob)blobs.get(1)).getContentIdentity()).thenReturn(blobIds.get(1));
        Mockito.when((Object)((Blob)blobs.get(2)).getContentIdentity()).thenReturn(blobIds.get(2));
        Mockito.when((Object)((Blob)blobs.get(3)).getContentIdentity()).thenReturn(blobIds.get(3));
        MemoryNodeStore nodeStore = new MemoryNodeStore();
        NodeBuilder rootBuilder = nodeStore.getRoot().builder();
        ArrayList builders = Lists.newArrayList();
        for (String path : paths) {
            NodeBuilder builder = rootBuilder;
            for (String nodeName : PathUtils.elements((String)path)) {
                builder = builder.child(nodeName);
            }
            builders.add(builder);
        }
        ((NodeBuilder)builders.get(0)).setProperty("blob1", blobs.get(0));
        ((NodeBuilder)builders.get(1)).setProperty("blob2", blobs.get(1));
        ((NodeBuilder)builders.get(2)).setProperty("blob3", blobs.get(2));
        ((NodeBuilder)builders.get(3)).setProperty("blob4", blobs.get(3));
        nodeStore.merge(rootBuilder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        ArrayList records = Lists.newArrayList();
        try {
            for (String s : blobContents) {
                records.add(this.autoSyncMockS3ds.addRecord(S3DataStoreStatsTest.getStream(s)));
            }
            for (String path : Lists.newArrayList((Object[])new String[]{"path/to/node/1", "path/to/node/2", "shortpath", "a/very/very/long/path/leads/to/node/4", "/path/to/node/1"})) {
                Assert.assertTrue((boolean)this.stats.isFileSynced(path));
            }
            for (String invalidPath : Lists.newArrayList((Object[])new String[]{"path/to/node/1/", "/path/to/node/1/", "/path//to/node///1"})) {
                try {
                    this.stats.isFileSynced(invalidPath);
                    Assert.assertFalse((boolean)false);
                }
                catch (AssertionError e) {}
            }
        }
        finally {
            S3DataStoreStatsTest.delete(this.autoSyncMockS3ds, records);
        }
    }

    @Test
    public void testIsFileSyncedMultiplePropertiesReturnsTrue() throws Exception {
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.of((Object)"abc"), (Optional<Integer>)Optional.of((Object)123), (Optional<List<Blob>>)Optional.absent());
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedTrue(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile));
    }

    @Test
    public void testIsFileSyncedMultipleBinaryPropertiesAllSyncedReturnsTrue() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.of((Object)mockBlob2), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.absent());
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedTrue(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile), S3DataStoreStatsTest.getStream("testContents2"));
    }

    @Test
    public void testIsFileSyncedMultipleBinaryPropertiesNotAllSyncedReturnsFalse() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.of((Object)mockBlob2), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.absent());
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile));
    }

    @Test
    public void testIsFileSyncedBinariesPropertySingleReturnsTrue() throws Exception {
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.absent(), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedTrue(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile));
    }

    @Test
    public void testIsFileSyncedBinariesPropertyMultipleReturnsTrue() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob, mockBlob2});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.absent(), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedTrue(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile), S3DataStoreStatsTest.getStream("testContents2"));
    }

    @Test
    public void testIsFileSyncedBinariesPropertyNotAllSyncedReturnsFalse() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob, mockBlob2});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.absent(), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile));
    }

    @Test
    public void testIsFileSyncedBinarySyncedAndBinariesNotSyncedReturnsFalse() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        Blob mockBlob3 = (Blob)Mockito.mock(Blob.class);
        String id3 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents3"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id3);
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob2, mockBlob3});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile), S3DataStoreStatsTest.getStream("testContents2"));
    }

    @Test
    public void testIsFileSyncedBinaryNotSyncedAndBinariesSyncedReturnsFalse() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        Blob mockBlob3 = (Blob)Mockito.mock(Blob.class);
        String id3 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents3"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id3);
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob2, mockBlob3});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.autoSyncMockS3ds, S3DataStoreStatsTest.getStream("testContents2"), S3DataStoreStatsTest.getStream("testContents3"));
    }

    @Test
    public void testIsFileSyncedBinaryAndBinariesSyncedReturnsTrue() throws Exception {
        Blob mockBlob2 = (Blob)Mockito.mock(Blob.class);
        String id2 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents2"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id2);
        Blob mockBlob3 = (Blob)Mockito.mock(Blob.class);
        String id3 = this.getIdForInputStream(S3DataStoreStatsTest.getStream("testContents3"));
        Mockito.when((Object)mockBlob2.getContentIdentity()).thenReturn((Object)id3);
        ArrayList blobPropList = Lists.newArrayList((Object[])new Blob[]{mockBlob2, mockBlob3});
        NodeStore nodeStore = S3DataStoreStatsTest.initNodeStore((Optional<Blob>)Optional.of((Object)mockBlob), (Optional<Blob>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<List<Blob>>)Optional.of((Object)blobPropList));
        this.stats = new S3DataStoreStats();
        this.stats.nodeStore = nodeStore;
        this.stats.s3ds = this.autoSyncMockS3ds;
        S3DataStoreStatsTest.assertSyncedFalse(this.stats, this.autoSyncMockS3ds, new FileInputStream(this.testFile), S3DataStoreStatsTest.getStream("testContents2"), S3DataStoreStatsTest.getStream("testContents3"));
    }

    private static void delete(SharedS3DataStore s3ds, List<DataRecord> recs) throws DataStoreException {
        for (DataRecord rec : recs) {
            if (null == rec) continue;
            s3ds.deleteRecord(rec.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertSyncedFalse(S3DataStoreStats mBean, SharedS3DataStore s3ds, InputStream ... streams) throws DataStoreException {
        ArrayList recs = Lists.newArrayList();
        try {
            for (InputStream is : streams) {
                recs.add(s3ds.addRecord(is));
                IOUtils.closeQuietly((InputStream)is);
            }
            Assert.assertFalse((boolean)mBean.isFileSynced(testNodePathName));
        }
        finally {
            S3DataStoreStatsTest.delete(s3ds, recs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertSyncedTrue(S3DataStoreStats mBean, SharedS3DataStore s3ds, InputStream ... streams) throws DataStoreException {
        ArrayList recs = Lists.newArrayList();
        try {
            for (InputStream is : streams) {
                recs.add(s3ds.addRecord(is));
                IOUtils.closeQuietly((InputStream)is);
            }
            Assert.assertTrue((boolean)mBean.isFileSynced(testNodePathName));
        }
        finally {
            S3DataStoreStatsTest.delete(s3ds, recs);
        }
    }

    private static InputStream getStream(String str) {
        return new ByteArrayInputStream(str.getBytes(Charsets.UTF_8));
    }

    private static InputStream randomStream(int seed, int size) {
        Random r = new Random(seed);
        byte[] data = new byte[size];
        r.nextBytes(data);
        return new ByteArrayInputStream(data);
    }

    static {
        testNodePathName = "test/node/path/name";
    }

    private class ManuallySyncingInMemoryBackend
    extends TestMemoryBackend {
        final Map<DataIdentifier, File> inProgessWrites;
        final Map<DataIdentifier, AsyncUploadCallback> asyncCallbacks;

        private ManuallySyncingInMemoryBackend() {
            this.inProgessWrites = Maps.newHashMap();
            this.asyncCallbacks = Maps.newHashMap();
        }

        @Override
        public void writeAsync(DataIdentifier identifier, File file, AsyncUploadCallback callback) throws DataStoreException {
            this.inProgessWrites.put(identifier, file);
            this.asyncCallbacks.put(identifier, callback);
        }

        void clearInProgressWrites() throws DataStoreException {
            for (DataIdentifier identifier : this.inProgessWrites.keySet()) {
                File file = this.inProgessWrites.get(identifier);
                this.asyncCallbacks.get(identifier).onSuccess(new AsyncUploadResult(identifier, file));
                this.write(identifier, file);
            }
            this.inProgessWrites.clear();
        }
    }

    private class TestMemoryBackend
    implements Backend {
        final Map<DataIdentifier, File> _backend = Maps.newHashMap();

        private TestMemoryBackend() {
        }

        public void init(CachingDataStore store, String homeDir, String config) throws DataStoreException {
        }

        public InputStream read(DataIdentifier identifier) throws DataStoreException {
            try {
                return new FileInputStream(this._backend.get(identifier));
            }
            catch (FileNotFoundException e) {
                throw new DataStoreException((Throwable)e);
            }
        }

        public long getLength(DataIdentifier identifier) throws DataStoreException {
            return this._backend.get(identifier).length();
        }

        public long getLastModified(DataIdentifier identifier) throws DataStoreException {
            return this._backend.get(identifier).lastModified();
        }

        public void write(DataIdentifier identifier, File file) throws DataStoreException {
            this._backend.put(identifier, file);
        }

        public void writeAsync(DataIdentifier identifier, File file, AsyncUploadCallback callback) throws DataStoreException {
            this.write(identifier, file);
            callback.onSuccess(new AsyncUploadResult(identifier, file));
        }

        public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
            return this._backend.keySet().iterator();
        }

        public boolean exists(DataIdentifier identifier, boolean touch) throws DataStoreException {
            if (this._backend.containsKey(identifier) && touch) {
                this.touch(identifier, new DateTime().getMillis());
            }
            return this.exists(identifier);
        }

        public boolean exists(DataIdentifier identifier) throws DataStoreException {
            return this._backend.containsKey(identifier);
        }

        public void touch(DataIdentifier identifier, long minModifiedDate) throws DataStoreException {
        }

        public void touchAsync(DataIdentifier identifier, long minModifiedDate, AsyncTouchCallback callback) throws DataStoreException {
            callback.onSuccess(new AsyncTouchResult(identifier));
        }

        public void close() throws DataStoreException {
        }

        public Set<DataIdentifier> deleteAllOlderThan(long timestamp) throws DataStoreException {
            HashSet toDelete = Sets.newHashSet();
            for (DataIdentifier identifier : this._backend.keySet()) {
                if (this._backend.get(identifier).lastModified() >= timestamp) continue;
                toDelete.add(identifier);
            }
            for (DataIdentifier identifier : toDelete) {
                this._backend.remove(identifier);
            }
            return toDelete;
        }

        public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
            if (this._backend.containsKey(identifier)) {
                this._backend.remove(identifier);
            }
        }
    }

    private class CustomBackendS3DataStore
    extends SharedS3DataStore {
        private Backend _localBackend;

        CustomBackendS3DataStore(Backend backend) {
            this._localBackend = backend;
        }

        protected Backend createBackend() {
            return this._localBackend;
        }
    }
}

