/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.aws.s3;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.S3Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DataStore
extends CachingDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(S3DataStore.class);
    protected Properties properties;

    protected Backend createBackend() {
        S3Backend backend = new S3Backend();
        if (this.properties != null) {
            backend.setProperties(this.properties);
        }
        return backend;
    }

    protected String getMarkerFile() {
        return "s3.init.done";
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean haveRecordForIdentifier(String identifier) {
        try {
            if (!Strings.isNullOrEmpty((String)identifier)) {
                return this.getBackend().exists(new DataIdentifier(identifier));
            }
        }
        catch (DataStoreException e) {
            LOG.warn(String.format("Data Store Exception caught checking for %s in pending uploads", identifier), (Throwable)e);
        }
        return false;
    }
}

