/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import com.google.common.base.Strings;
import java.util.Locale;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.wicket.util.convert.IConverter;

public class ConverterForObjectAdapterMemento
implements IConverter<ObjectAdapterMemento> {
    private static final long serialVersionUID = 1L;

    public ObjectAdapterMemento convertToObject(String value, Locale locale) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        RootOid oid = RootOidDefault.deStringEncoded((String)value, (OidMarshaller)this.getOidMarshaller());
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor((Oid)oid);
        return ObjectAdapterMemento.createOrNull((ObjectAdapter)adapter);
    }

    public String convertToString(ObjectAdapterMemento memento, Locale locale) {
        if (memento == null) {
            return null;
        }
        Oid oid = memento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK).getOid();
        if (oid == null) {
            return memento.toString();
        }
        return oid.enString(this.getOidMarshaller());
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }
}

