/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.imagecache;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import images.Images;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.viewer.imagecache.ImageResourceCacheKey;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

@Singleton
public class ImageResourceCacheClassPath
implements ImageResourceCache {
    private static final long serialVersionUID = 1L;
    private static final List<String> IMAGE_SUFFICES = Arrays.asList("png", "gif", "jpeg", "jpg");
    private static final String FALLBACK_IMAGE = "Default.png";
    private final Map<ImageResourceCacheKey, ResourceReference> resourceReferenceByKey = Maps.newConcurrentMap();
    private final PackageResourceReference fallbackResource = new PackageResourceReference(Images.class, "Default.png");

    public ImageResourceCacheClassPath() {
        this.resourceReferenceByKey.put(new ImageResourceCacheKey(null, null), (ResourceReference)this.fallbackResource);
    }

    public ResourceReference resourceReferenceFor(ObjectAdapter adapter) {
        return this.resourceReferenceFor(adapter.getSpecification(), adapter.getIconName());
    }

    public ResourceReference resourceReferenceForSpec(ObjectSpecification spec) {
        return this.resourceReferenceFor(spec, null);
    }

    private ResourceReference resourceReferenceFor(ObjectSpecification specification, String iconNameIfAny) {
        Class correspondingClassIfAny = specification != null ? specification.getCorrespondingClass() : null;
        ImageResourceCacheKey key = new ImageResourceCacheKey(correspondingClassIfAny, iconNameIfAny);
        ResourceReference resourceReference = this.resourceReferenceByKey.get(key);
        if (resourceReference == null) {
            resourceReference = this.findResourceReferenceFor(key);
            this.resourceReferenceByKey.put(key, resourceReference);
        }
        return resourceReference;
    }

    protected ResourceReference findResourceReferenceFor(ImageResourceCacheKey key) {
        List<ImageResourceCacheKey> keys = key.resourcePaths(IMAGE_SUFFICES);
        for (ImageResourceCacheKey resourceKey : keys) {
            String iconName;
            InputStream resourceAsStream;
            Class<Object> resourceClass = resourceKey.getResourceClass();
            if (resourceClass == null) {
                resourceClass = Images.class;
            }
            if ((resourceAsStream = resourceClass.getResourceAsStream(iconName = resourceKey.getResourceName())) == null) continue;
            ImageResourceCacheClassPath.closeSafely(resourceAsStream);
            return new PackageResourceReference(resourceClass, iconName);
        }
        return this.fallbackResource;
    }

    private static void closeSafely(InputStream resourceAsStream) {
        try {
            resourceAsStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

