/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Locale;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;

public class GridJettyObjectMapper
extends ObjectMapper {
    private static final JsonSerializer<Object> NULL_KEY_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeFieldName("");
        }
    };
    private static final JsonSerializer<Object> NULL_VALUE_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeNull();
        }
    };
    private static final JsonSerializer<Throwable> THROWABLE_SERIALIZER = new JsonSerializer<Throwable>(){

        private void writeException(Throwable e, JsonGenerator gen) throws IOException {
            if (e instanceof VisorExceptionWrapper) {
                VisorExceptionWrapper wrapper = (VisorExceptionWrapper)e;
                gen.writeStringField("className", wrapper.getClassName());
            } else {
                gen.writeStringField("className", e.getClass().getName());
            }
            if (e.getMessage() != null) {
                gen.writeStringField("message", e.getMessage());
            }
            if (e instanceof SQLException) {
                SQLException sqlE = (SQLException)e;
                gen.writeNumberField("errorCode", sqlE.getErrorCode());
                gen.writeStringField("SQLState", sqlE.getSQLState());
            }
        }

        public void serialize(Throwable e, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            this.writeException(e, gen);
            if (e.getCause() != null) {
                gen.writeObjectField("cause", (Object)e.getCause());
            }
            if (!F.isEmpty((Object[])e.getSuppressed())) {
                gen.writeArrayFieldStart("suppressed");
                for (Throwable sup : e.getSuppressed()) {
                    gen.writeObject((Object)sup);
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<IgniteUuid> IGNITE_UUID_SERIALIZER = new JsonSerializer<IgniteUuid>(){

        public void serialize(IgniteUuid uid, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeString(uid.toString());
        }
    };
    private static final JsonSerializer<IgniteBiTuple> IGNITE_TUPLE_SERIALIZER = new JsonSerializer<IgniteBiTuple>(){

        public void serialize(IgniteBiTuple t, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("key", t.getKey());
            gen.writeObjectField("value", t.getValue());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlMetadata> IGNITE_SQL_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlMetadata>(){

        public void serialize(GridCacheSqlMetadata m, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("cacheName", m.cacheName());
            gen.writeObjectField("types", (Object)m.types());
            gen.writeObjectField("keyClasses", (Object)m.keyClasses());
            gen.writeObjectField("valClasses", (Object)m.valClasses());
            gen.writeObjectField("fields", (Object)m.fields());
            gen.writeObjectField("indexes", (Object)m.indexes());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlIndexMetadata> IGNITE_SQL_INDEX_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlIndexMetadata>(){

        public void serialize(GridCacheSqlIndexMetadata idx, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", idx.name());
            gen.writeObjectField("fields", (Object)idx.fields());
            gen.writeObjectField("descendings", (Object)idx.descendings());
            gen.writeBooleanField("unique", idx.unique());
            gen.writeEndObject();
        }
    };

    public GridJettyObjectMapper() {
        super(null, (DefaultSerializerProvider)new CustomSerializerProvider(), null);
        this.setDateFormat(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        SimpleModule module = new SimpleModule();
        module.addSerializer(Throwable.class, THROWABLE_SERIALIZER);
        module.addSerializer(IgniteBiTuple.class, IGNITE_TUPLE_SERIALIZER);
        module.addSerializer(IgniteUuid.class, IGNITE_UUID_SERIALIZER);
        module.addSerializer(GridCacheSqlMetadata.class, IGNITE_SQL_METADATA_SERIALIZER);
        module.addSerializer(GridCacheSqlIndexMetadata.class, IGNITE_SQL_INDEX_METADATA_SERIALIZER);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.registerModule((Module)module);
    }

    private static class CustomSerializerProvider
    extends DefaultSerializerProvider {
        CustomSerializerProvider() {
        }

        CustomSerializerProvider(SerializerProvider src, SerializationConfig cfg, SerializerFactory f) {
            super(src, cfg, f);
        }

        public DefaultSerializerProvider createInstance(SerializationConfig cfg, SerializerFactory jsf) {
            return new CustomSerializerProvider((SerializerProvider)this, cfg, jsf);
        }

        public JsonSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty prop) throws JsonMappingException {
            return NULL_KEY_SERIALIZER;
        }

        public JsonSerializer<Object> findNullValueSerializer(BeanProperty prop) throws JsonMappingException {
            return NULL_VALUE_SERIALIZER;
        }
    }
}

