/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class SnowflakeIdentifier {
    private final String databaseName;
    private final String schemaName;
    private final String tableName;
    private final Type type;

    private SnowflakeIdentifier(String databaseName, String schemaName, String tableName, Type type) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = type;
    }

    public static SnowflakeIdentifier ofRoot() {
        return new SnowflakeIdentifier(null, null, null, Type.ROOT);
    }

    public static SnowflakeIdentifier ofDatabase(String databaseName) {
        Preconditions.checkArgument((null != databaseName ? 1 : 0) != 0, (Object)"databaseName must be non-null");
        return new SnowflakeIdentifier(databaseName, null, null, Type.DATABASE);
    }

    public static SnowflakeIdentifier ofSchema(String databaseName, String schemaName) {
        Preconditions.checkArgument((null != databaseName ? 1 : 0) != 0, (Object)"databaseName must be non-null");
        Preconditions.checkArgument((null != schemaName ? 1 : 0) != 0, (Object)"schemaName must be non-null");
        return new SnowflakeIdentifier(databaseName, schemaName, null, Type.SCHEMA);
    }

    public static SnowflakeIdentifier ofTable(String databaseName, String schemaName, String tableName) {
        Preconditions.checkArgument((null != databaseName ? 1 : 0) != 0, (Object)"databaseName must be non-null");
        Preconditions.checkArgument((null != schemaName ? 1 : 0) != 0, (Object)"schemaName must be non-null");
        Preconditions.checkArgument((null != tableName ? 1 : 0) != 0, (Object)"tableName must be non-null");
        return new SnowflakeIdentifier(databaseName, schemaName, tableName, Type.TABLE);
    }

    public Type type() {
        return this.type;
    }

    public String tableName() {
        return this.tableName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnowflakeIdentifier)) {
            return false;
        }
        SnowflakeIdentifier that = (SnowflakeIdentifier)o;
        return Objects.equal((Object)this.databaseName, (Object)that.databaseName) && Objects.equal((Object)this.schemaName, (Object)that.schemaName) && Objects.equal((Object)this.tableName, (Object)that.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseName, this.schemaName, this.tableName});
    }

    public String toIdentifierString() {
        switch (this.type()) {
            case TABLE: {
                return String.format("%s.%s.%s", this.databaseName, this.schemaName, this.tableName);
            }
            case SCHEMA: {
                return String.format("%s.%s", this.databaseName, this.schemaName);
            }
            case DATABASE: {
                return this.databaseName;
            }
        }
        return "";
    }

    public String toString() {
        return String.format("%s: '%s'", new Object[]{this.type(), this.toIdentifierString()});
    }

    public static enum Type {
        ROOT,
        DATABASE,
        SCHEMA,
        TABLE;

    }
}

