/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.orc.GenericOrcWriters;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcBatchReader;
import org.apache.iceberg.orc.OrcFileAppender;
import org.apache.iceberg.orc.OrcIterable;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;

public class ORC {
    @Deprecated
    private static final String VECTOR_ROW_BATCH_SIZE = "iceberg.orc.vectorbatch.size";

    private ORC() {
    }

    public static WriteBuilder write(OutputFile file) {
        return new WriteBuilder(file);
    }

    public static DataWriteBuilder writeData(OutputFile file) {
        return new DataWriteBuilder(file);
    }

    public static DeleteWriteBuilder writeDeletes(OutputFile file) {
        return new DeleteWriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    static Reader newFileReader(String location, OrcFile.ReaderOptions readerOptions) {
        try {
            return OrcFile.createReader((Path)new Path(location), (OrcFile.ReaderOptions)readerOptions);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", new Object[]{location});
        }
    }

    static Reader newFileReader(InputFile file, Configuration config) {
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)config).useUTCTimestamp(true);
        if (file instanceof HadoopInputFile) {
            readerOptions.filesystem(((HadoopInputFile)file).getFileSystem());
        }
        return ORC.newFileReader(file.location(), readerOptions);
    }

    public static class ReadBuilder {
        private final InputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private Long start = null;
        private Long length = null;
        private Expression filter = null;
        private boolean caseSensitive = true;
        private NameMapping nameMapping = null;
        private Function<TypeDescription, OrcRowReader<?>> readerFunc;
        private Function<TypeDescription, OrcBatchReader<?>> batchedReaderFunc;
        private int recordsPerBatch = 1024;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull((Object)file, (Object)"Input file cannot be null");
            this.file = file;
            this.conf = file instanceof HadoopInputFile ? new Configuration(((HadoopInputFile)file).getConf()) : new Configuration();
            this.conf.setBoolean(OrcConf.FORCE_POSITIONAL_EVOLUTION.getHiveConfName(), false);
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ReadBuilder caseSensitive(boolean newCaseSensitive) {
            OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(this.conf, newCaseSensitive);
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public ReadBuilder config(String property, String value) {
            this.conf.set(property, value);
            return this;
        }

        public ReadBuilder createReaderFunc(Function<TypeDescription, OrcRowReader<?>> readerFunction) {
            Preconditions.checkArgument((this.batchedReaderFunc == null ? 1 : 0) != 0, (Object)"Reader function cannot be set since the batched version is already set");
            this.readerFunc = readerFunction;
            return this;
        }

        public ReadBuilder filter(Expression newFilter) {
            this.filter = newFilter;
            return this;
        }

        public ReadBuilder createBatchedReaderFunc(Function<TypeDescription, OrcBatchReader<?>> batchReaderFunction) {
            Preconditions.checkArgument((this.readerFunc == null ? 1 : 0) != 0, (Object)"Batched reader function cannot be set since the non-batched version is already set");
            this.batchedReaderFunc = batchReaderFunction;
            return this;
        }

        public ReadBuilder recordsPerBatch(int numRecordsPerBatch) {
            this.recordsPerBatch = numRecordsPerBatch;
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public <D> CloseableIterable<D> build() {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            return new OrcIterable(this.file, this.conf, this.schema, this.nameMapping, this.start, this.length, this.readerFunc, this.caseSensitive, this.filter, this.batchedReaderFunc, this.recordsPerBatch);
        }
    }

    public static class DeleteWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private BiFunction<Schema, TypeDescription, OrcRowWriter<?>> createWriterFunc = null;
        private Schema rowSchema = null;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private int[] equalityFieldIds = null;
        private SortOrder sortOrder;
        private Function<CharSequence, ?> pathTransformFunc = Function.identity();

        private DeleteWriteBuilder(OutputFile file) {
            this.appenderBuilder = ORC.write(file);
            this.location = file.location();
        }

        public DeleteWriteBuilder forTable(Table table) {
            this.rowSchema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public DeleteWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DeleteWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DeleteWriteBuilder meta(String property, String value) {
            this.appenderBuilder.metadata(property, value);
            return this;
        }

        public DeleteWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DeleteWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DeleteWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(BiFunction<Schema, TypeDescription, OrcRowWriter<?>> newWriterFunc) {
            this.createWriterFunc = newWriterFunc;
            return this;
        }

        public DeleteWriteBuilder rowSchema(Schema newSchema) {
            this.rowSchema = newSchema;
            return this;
        }

        public DeleteWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DeleteWriteBuilder withPartition(StructLike key) {
            this.partition = key;
            return this;
        }

        public DeleteWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(List<Integer> fieldIds) {
            this.equalityFieldIds = ArrayUtil.toIntArray(fieldIds);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(int ... fieldIds) {
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public DeleteWriteBuilder transformPaths(Function<CharSequence, ?> newPathTransformFunc) {
            this.pathTransformFunc = newPathTransformFunc;
            return this;
        }

        public DeleteWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> EqualityDeleteWriter<T> buildEqualityWriter() {
            Preconditions.checkState((this.rowSchema != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file without a schema");
            Preconditions.checkState((this.equalityFieldIds != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file without delete field ids");
            Preconditions.checkState((this.createWriterFunc != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file unless createWriterFunc is set");
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Spec must not be null when creating equality delete writer");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null for partitioned writes");
            this.meta("delete-type", "equality");
            this.meta("delete-field-ids", IntStream.of(this.equalityFieldIds).mapToObj(Objects::toString).collect(Collectors.joining(", ")));
            this.appenderBuilder.schema(this.rowSchema);
            this.appenderBuilder.createWriterFunc(this.createWriterFunc);
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new EqualityDeleteWriter(this.appenderBuilder.build(), FileFormat.ORC, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder, this.equalityFieldIds);
        }

        public <T> PositionDeleteWriter<T> buildPositionWriter() {
            Preconditions.checkState((this.equalityFieldIds == null ? 1 : 0) != 0, (Object)"Cannot create position delete file using delete field ids");
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Spec must not be null when creating position delete writer");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null for partitioned writes");
            Preconditions.checkArgument((this.rowSchema == null || this.createWriterFunc != null ? 1 : 0) != 0, (Object)"Create function should be provided if we write row data");
            this.meta("delete-type", "position");
            if (this.rowSchema != null && this.createWriterFunc != null) {
                Schema deleteSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.rowSchema);
                this.appenderBuilder.schema(deleteSchema);
                this.appenderBuilder.createWriterFunc((schema, typeDescription) -> GenericOrcWriters.positionDelete(this.createWriterFunc.apply(deleteSchema, (TypeDescription)typeDescription), this.pathTransformFunc));
            } else {
                this.appenderBuilder.schema(DeleteSchemaUtil.pathPosSchema());
                this.appenderBuilder.createWriterFunc((schema, typeDescription) -> GenericOrcWriters.positionDelete(GenericOrcWriter.buildWriter(schema, typeDescription), Function.identity()));
            }
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new PositionDeleteWriter(this.appenderBuilder.build(), FileFormat.ORC, this.location, this.spec, this.partition, this.keyMetadata);
        }
    }

    public static class DataWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private SortOrder sortOrder = null;

        private DataWriteBuilder(OutputFile file) {
            this.appenderBuilder = ORC.write(file);
            this.location = file.location();
        }

        public DataWriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public DataWriteBuilder schema(Schema newSchema) {
            this.appenderBuilder.schema(newSchema);
            return this;
        }

        public DataWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DataWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DataWriteBuilder meta(String property, String value) {
            this.appenderBuilder.metadata(property, value);
            return this;
        }

        public DataWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DataWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DataWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DataWriteBuilder createWriterFunc(BiFunction<Schema, TypeDescription, OrcRowWriter<?>> writerFunction) {
            this.appenderBuilder.createWriterFunc(writerFunction);
            return this;
        }

        public DataWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DataWriteBuilder withPartition(StructLike newPartition) {
            this.partition = newPartition;
            return this;
        }

        public DataWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DataWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> DataWriter<T> build() {
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Cannot create data writer without spec");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null when creating data writer for partitioned spec");
            FileAppender fileAppender = this.appenderBuilder.build();
            return new DataWriter(fileAppender, FileFormat.ORC, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder);
        }
    }

    public static class WriteBuilder {
        private final OutputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private BiFunction<Schema, TypeDescription, OrcRowWriter<?>> createWriterFunc;
        private Map<String, byte[]> metadata = Maps.newHashMap();
        private MetricsConfig metricsConfig;
        private Function<Map<String, String>, Context> createContextFunc = Context::dataContext;
        private final Map<String, String> config = Maps.newLinkedHashMap();
        private boolean overwrite = false;

        private WriteBuilder(OutputFile file) {
            this.file = file;
            this.conf = file instanceof HadoopOutputFile ? new Configuration(((HadoopOutputFile)file).getConf()) : new Configuration();
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public WriteBuilder metadata(String property, String value) {
            this.metadata.put(property, value.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        @Deprecated
        public WriteBuilder config(String property, String value) {
            return this.set(property, value);
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(BiFunction<Schema, TypeDescription, OrcRowWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.overwrite = enabled;
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        private WriteBuilder createContextFunc(Function<Map<String, String>, Context> newCreateContextFunc) {
            this.createContextFunc = newCreateContextFunc;
            return this;
        }

        public <D> FileAppender<D> build() {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                this.conf.set(entry.getKey(), entry.getValue());
            }
            if (this.conf.get(ORC.VECTOR_ROW_BATCH_SIZE) != null && this.config.get("write.orc.vectorized.batch-size") == null) {
                this.config.put("write.orc.vectorized.batch-size", this.conf.get(ORC.VECTOR_ROW_BATCH_SIZE));
            }
            Context context = this.createContextFunc.apply(this.config);
            OrcConf.STRIPE_SIZE.setLong(this.conf, context.stripeSize());
            OrcConf.BLOCK_SIZE.setLong(this.conf, context.blockSize());
            OrcConf.COMPRESS.setString(this.conf, context.compressionKind().name());
            OrcConf.COMPRESSION_STRATEGY.setString(this.conf, context.compressionStrategy().name());
            OrcConf.OVERWRITE_OUTPUT_FILE.setBoolean(this.conf, this.overwrite);
            return new OrcFileAppender(this.schema, this.file, this.createWriterFunc, this.conf, this.metadata, context.vectorizedRowBatchSize(), this.metricsConfig);
        }

        private static class Context {
            private final long stripeSize;
            private final long blockSize;
            private final int vectorizedRowBatchSize;
            private final CompressionKind compressionKind;
            private final OrcFile.CompressionStrategy compressionStrategy;

            public long stripeSize() {
                return this.stripeSize;
            }

            public long blockSize() {
                return this.blockSize;
            }

            public int vectorizedRowBatchSize() {
                return this.vectorizedRowBatchSize;
            }

            public CompressionKind compressionKind() {
                return this.compressionKind;
            }

            public OrcFile.CompressionStrategy compressionStrategy() {
                return this.compressionStrategy;
            }

            private Context(long stripeSize, long blockSize, int vectorizedRowBatchSize, CompressionKind compressionKind, OrcFile.CompressionStrategy compressionStrategy) {
                this.stripeSize = stripeSize;
                this.blockSize = blockSize;
                this.vectorizedRowBatchSize = vectorizedRowBatchSize;
                this.compressionKind = compressionKind;
                this.compressionStrategy = compressionStrategy;
            }

            static Context dataContext(Map<String, String> config) {
                long stripeSize = PropertyUtil.propertyAsLong(config, (String)OrcConf.STRIPE_SIZE.getAttribute(), (long)0x4000000L);
                Preconditions.checkArgument(((stripeSize = PropertyUtil.propertyAsLong(config, (String)"write.orc.stripe-size-bytes", (long)stripeSize)) > 0L ? 1 : 0) != 0, (Object)"Stripe size must be > 0");
                long blockSize = PropertyUtil.propertyAsLong(config, (String)OrcConf.BLOCK_SIZE.getAttribute(), (long)0x10000000L);
                blockSize = PropertyUtil.propertyAsLong(config, (String)"write.orc.block-size-bytes", (long)blockSize);
                Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (Object)"Block size must be > 0");
                int vectorizedRowBatchSize = PropertyUtil.propertyAsInt(config, (String)"write.orc.vectorized.batch-size", (int)1024);
                Preconditions.checkArgument((vectorizedRowBatchSize > 0 ? 1 : 0) != 0, (Object)"VectorizedRow batch size must be > 0");
                String codecAsString = PropertyUtil.propertyAsString(config, (String)OrcConf.COMPRESS.getAttribute(), (String)"zlib");
                codecAsString = PropertyUtil.propertyAsString(config, (String)"write.orc.compression-codec", (String)codecAsString);
                CompressionKind compressionKind = Context.toCompressionKind(codecAsString);
                String strategyAsString = PropertyUtil.propertyAsString(config, (String)OrcConf.COMPRESSION_STRATEGY.getAttribute(), (String)"speed");
                strategyAsString = PropertyUtil.propertyAsString(config, (String)"write.orc.compression-strategy", (String)strategyAsString);
                OrcFile.CompressionStrategy compressionStrategy = Context.toCompressionStrategy(strategyAsString);
                return new Context(stripeSize, blockSize, vectorizedRowBatchSize, compressionKind, compressionStrategy);
            }

            static Context deleteContext(Map<String, String> config) {
                Context dataContext = Context.dataContext(config);
                long stripeSize = PropertyUtil.propertyAsLong(config, (String)"write.delete.orc.stripe-size-bytes", (long)dataContext.stripeSize());
                long blockSize = PropertyUtil.propertyAsLong(config, (String)"write.delete.orc.block-size-bytes", (long)dataContext.blockSize());
                int vectorizedRowBatchSize = PropertyUtil.propertyAsInt(config, (String)"write.delete.orc.vectorized.batch-size", (int)dataContext.vectorizedRowBatchSize());
                String codecAsString = config.get("write.delete.orc.compression-codec");
                CompressionKind compressionKind = codecAsString != null ? Context.toCompressionKind(codecAsString) : dataContext.compressionKind();
                String strategyAsString = config.get("write.delete.orc.compression-strategy");
                OrcFile.CompressionStrategy compressionStrategy = strategyAsString != null ? Context.toCompressionStrategy(strategyAsString) : dataContext.compressionStrategy();
                return new Context(stripeSize, blockSize, vectorizedRowBatchSize, compressionKind, compressionStrategy);
            }

            private static CompressionKind toCompressionKind(String codecAsString) {
                try {
                    return CompressionKind.valueOf((String)codecAsString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unsupported compression codec: " + codecAsString);
                }
            }

            private static OrcFile.CompressionStrategy toCompressionStrategy(String strategyAsString) {
                try {
                    return OrcFile.CompressionStrategy.valueOf((String)strategyAsString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unsupported compression strategy: " + strategyAsString);
                }
            }
        }
    }
}

