/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcMetrics;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.util.Tasks;

public class TableMigrationUtil {
    private static final PathFilter HIDDEN_PATH_FILTER = p -> !p.getName().startsWith("_") && !p.getName().startsWith(".");

    private TableMigrationUtil() {
    }

    public static List<DataFile> listPartition(Map<String, String> partition, String uri, String format, PartitionSpec spec, Configuration conf, MetricsConfig metricsConfig, NameMapping mapping) {
        return TableMigrationUtil.listPartition(partition, uri, format, spec, conf, metricsConfig, mapping, 1);
    }

    public static List<DataFile> listPartition(Map<String, String> partitionPath, String partitionUri, String format, PartitionSpec spec, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping, int parallelism) {
        try {
            String partitionKey = spec.fields().stream().map(PartitionField::name).map(name -> String.format("%s=%s", name, partitionPath.get(name))).collect(Collectors.joining("/"));
            Path partition = new Path(partitionUri);
            FileSystem fs = partition.getFileSystem(conf);
            List fileStatus = Arrays.stream(fs.listStatus(partition, HIDDEN_PATH_FILTER)).filter(FileStatus::isFile).collect(Collectors.toList());
            DataFile[] datafiles = new DataFile[fileStatus.size()];
            Tasks.Builder task = Tasks.range((int)fileStatus.size()).stopOnFailure().throwFailureWhenFinished();
            if (parallelism > 1) {
                task.executeWith(TableMigrationUtil.migrationService(parallelism));
            }
            if (format.contains("avro")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getAvroMerics(((FileStatus)fileStatus.get((int)index)).getPath(), conf);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "avro");
                });
            } else if (format.contains("parquet")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getParquetMerics(((FileStatus)fileStatus.get((int)index)).getPath(), conf, metricsSpec, mapping);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "parquet");
                });
            } else if (format.contains("orc")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getOrcMerics(((FileStatus)fileStatus.get((int)index)).getPath(), conf, metricsSpec, mapping);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "orc");
                });
            } else {
                throw new UnsupportedOperationException("Unknown partition format: " + format);
            }
            return Arrays.asList(datafiles);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in partition: " + partitionUri, e);
        }
    }

    private static Metrics getAvroMerics(Path path, Configuration conf) {
        try {
            HadoopInputFile file = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
            long rowCount = Avro.rowCount((InputFile)file);
            return new Metrics(Long.valueOf(rowCount), null, null, null, null);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read Avro file: " + path, e);
        }
    }

    private static Metrics getParquetMerics(Path path, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            HadoopInputFile file = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
            return ParquetUtil.fileMetrics((InputFile)file, (MetricsConfig)metricsSpec, (NameMapping)mapping);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read the metrics of the Parquet file: " + path, e);
        }
    }

    private static Metrics getOrcMerics(Path path, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            return OrcMetrics.fromInputFile((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)conf), (MetricsConfig)metricsSpec, (NameMapping)mapping);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read the metrics of the Orc file: " + path, e);
        }
    }

    private static DataFile buildDataFile(FileStatus stat, String partitionKey, PartitionSpec spec, Metrics metrics, String format) {
        return DataFiles.builder((PartitionSpec)spec).withPath(stat.getPath().toString()).withFormat(format).withFileSizeInBytes(stat.getLen()).withMetrics(metrics).withPartitionPath(partitionKey).build();
    }

    private static ExecutorService migrationService(int concurrentDeletes) {
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(concurrentDeletes, new ThreadFactoryBuilder().setNameFormat("table-migration-%d").build())));
    }
}

