/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.util.PropertyUtil;

public class AzureProperties
implements Serializable {
    public static final String ADLS_SAS_TOKEN_PREFIX = "adls.sas-token.";
    public static final String ADLS_CONNECTION_STRING_PREFIX = "adls.connection-string.";
    public static final String ADLS_READ_BLOCK_SIZE = "adls.read.block-size-bytes";
    public static final String ADLS_WRITE_BLOCK_SIZE = "adls.write.block-size-bytes";
    private Map<String, String> adlsSasTokens = Collections.emptyMap();
    private Map<String, String> adlsConnectionStrings = Collections.emptyMap();
    private Integer adlsReadBlockSize;
    private Long adlsWriteBlockSize;

    public AzureProperties() {
    }

    public AzureProperties(Map<String, String> properties) {
        this.adlsSasTokens = PropertyUtil.propertiesWithPrefix(properties, (String)ADLS_SAS_TOKEN_PREFIX);
        this.adlsConnectionStrings = PropertyUtil.propertiesWithPrefix(properties, (String)ADLS_CONNECTION_STRING_PREFIX);
        if (properties.containsKey(ADLS_READ_BLOCK_SIZE)) {
            this.adlsReadBlockSize = Integer.parseInt(properties.get(ADLS_READ_BLOCK_SIZE));
        }
        if (properties.containsKey(ADLS_WRITE_BLOCK_SIZE)) {
            this.adlsWriteBlockSize = Long.parseLong(properties.get(ADLS_WRITE_BLOCK_SIZE));
        }
    }

    public Optional<Integer> adlsReadBlockSize() {
        return Optional.ofNullable(this.adlsReadBlockSize);
    }

    public Optional<Long> adlsWriteBlockSize() {
        return Optional.ofNullable(this.adlsWriteBlockSize);
    }

    public void applyClientConfiguration(String account, DataLakeFileSystemClientBuilder builder) {
        String sasToken = this.adlsSasTokens.get(account);
        if (sasToken != null && !sasToken.isEmpty()) {
            builder.sasToken(sasToken);
        } else {
            builder.credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
        }
        String connectionString = this.adlsConnectionStrings.get(account);
        if (connectionString != null && !connectionString.isEmpty()) {
            builder.endpoint(connectionString);
        } else {
            builder.endpoint("https://" + account);
        }
    }
}

