/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedPageIterator;
import org.apache.iceberg.parquet.BaseColumnIterator;
import org.apache.iceberg.parquet.BasePageIterator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReader;

public class VectorizedColumnIterator
extends BaseColumnIterator {
    private final VectorizedPageIterator vectorizedPageIterator;
    private int batchSize;

    public VectorizedColumnIterator(ColumnDescriptor desc, String writerVersion, boolean setArrowValidityVector) {
        super(desc);
        Preconditions.checkArgument((desc.getMaxRepetitionLevel() == 0 ? 1 : 0) != 0, (Object)"Only non-nested columns are supported for vectorized reads");
        this.vectorizedPageIterator = new VectorizedPageIterator(desc, writerVersion, setArrowValidityVector);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Dictionary setRowGroupInfo(PageReader store, boolean allPagesDictEncoded) {
        this.vectorizedPageIterator.setAllPagesDictEncoded(allPagesDictEncoded);
        super.setPageSource(store);
        return this.dictionary;
    }

    protected BasePageIterator pageIterator() {
        return this.vectorizedPageIterator;
    }

    public boolean producesDictionaryEncodedVector() {
        return this.vectorizedPageIterator.producesDictionaryEncodedVector();
    }

    public IntegerBatchReader integerBatchReader() {
        return new IntegerBatchReader();
    }

    public DictionaryBatchReader dictionaryBatchReader() {
        return new DictionaryBatchReader();
    }

    public LongBatchReader longBatchReader() {
        return new LongBatchReader();
    }

    public TimestampMillisBatchReader timestampMillisBatchReader() {
        return new TimestampMillisBatchReader();
    }

    public TimestampInt96BatchReader timestampInt96BatchReader() {
        return new TimestampInt96BatchReader();
    }

    public FloatBatchReader floatBatchReader() {
        return new FloatBatchReader();
    }

    public DoubleBatchReader doubleBatchReader() {
        return new DoubleBatchReader();
    }

    @Deprecated
    public IntBackedDecimalBatchReader intBackedDecimalBatchReader() {
        return new IntBackedDecimalBatchReader();
    }

    @Deprecated
    public LongBackedDecimalBatchReader longBackedDecimalBatchReader() {
        return new LongBackedDecimalBatchReader();
    }

    @Deprecated
    public FixedLengthDecimalBatchReader fixedLengthDecimalBatchReader() {
        return new FixedLengthDecimalBatchReader();
    }

    public FixedSizeBinaryBatchReader fixedSizeBinaryBatchReader() {
        return new FixedSizeBinaryBatchReader();
    }

    public VarWidthTypeBatchReader varWidthTypeBatchReader() {
        return new VarWidthTypeBatchReader();
    }

    public FixedWidthTypeBinaryBatchReader fixedWidthTypeBinaryBatchReader() {
        return new FixedWidthTypeBinaryBatchReader();
    }

    public BooleanBatchReader booleanBatchReader() {
        return new BooleanBatchReader();
    }

    public class BooleanBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.booleanPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class FixedWidthTypeBinaryBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.fixedWidthBinaryPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class VarWidthTypeBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.varWidthTypePageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class FixedSizeBinaryBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.fixedSizeBinaryPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    @Deprecated
    public class FixedLengthDecimalBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.fixedLengthDecimalPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    @Deprecated
    public class LongBackedDecimalBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.longBackedDecimalPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    @Deprecated
    public class IntBackedDecimalBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.intBackedDecimalPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class DoubleBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.doublePageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class FloatBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.floatPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class TimestampInt96BatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.timestampInt96PageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class TimestampMillisBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.timestampMillisPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class LongBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.longPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public class DictionaryBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.nextBatchDictionaryIds((IntVector)vector, expectedBatchSize, numValsInVector, holder);
        }
    }

    public class IntegerBatchReader
    extends BatchReader {
        @Override
        protected int nextBatchOf(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            return VectorizedColumnIterator.this.vectorizedPageIterator.intPageReader().nextBatch(vector, expectedBatchSize, numValsInVector, typeWidth, holder);
        }
    }

    public abstract class BatchReader {
        public void nextBatch(FieldVector fieldVector, int typeWidth, NullabilityHolder holder) {
            int rowsReadSoFar = 0;
            while (rowsReadSoFar < VectorizedColumnIterator.this.batchSize && VectorizedColumnIterator.this.hasNext()) {
                VectorizedColumnIterator.this.advance();
                int rowsInThisBatch = this.nextBatchOf(fieldVector, VectorizedColumnIterator.this.batchSize - rowsReadSoFar, rowsReadSoFar, typeWidth, holder);
                VectorizedColumnIterator.this.triplesRead += rowsInThisBatch;
                fieldVector.setValueCount(rowsReadSoFar += rowsInThisBatch);
            }
        }

        protected abstract int nextBatchOf(FieldVector var1, int var2, int var3, int var4, NullabilityHolder var5);
    }
}

