/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.JavaInsertOverwriteCommitActionExecutor;

public class JavaInsertOverwriteTableCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends JavaInsertOverwriteCommitActionExecutor<T> {
    public JavaInsertOverwriteTableCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords) {
        super(context, config, table, instantTime, inputRecords, WriteOperationType.INSERT_OVERWRITE_TABLE);
    }

    protected List<String> getAllExistingFileIds(String partitionPath) {
        return this.table.getSliceView().getLatestFileSlices(partitionPath).map(fg -> fg.getFileId()).distinct().collect(Collectors.toList());
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<List<WriteStatus>> writeResult) {
        Map<String, List<String>> partitionToExistingFileIds = new HashMap<String, List<String>>();
        List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (String)this.table.getMetaClient().getBasePath(), (boolean)this.config.isMetadataTableEnabled(), (boolean)this.config.shouldAssumeDatePartitioning());
        if (partitionPaths != null && partitionPaths.size() > 0) {
            partitionToExistingFileIds = this.context.mapToPair(partitionPaths, (SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)), Integer.valueOf(1));
        }
        return partitionToExistingFileIds;
    }
}

