/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.JavaTaskContextSupplier;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.ClusteringOperation;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieFileSliceReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.execution.bulkinsert.JavaBulkInsertInternalPartitionerFactory;
import org.apache.hudi.execution.bulkinsert.JavaCustomColumnsSortPartitioner;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.cluster.strategy.ClusteringExecutionStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class JavaExecutionStrategy<T extends HoodieRecordPayload<T>>
extends ClusteringExecutionStrategy<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(JavaExecutionStrategy.class);

    public JavaExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public HoodieWriteMetadata<HoodieData<WriteStatus>> performClustering(HoodieClusteringPlan clusteringPlan, Schema schema, String instantTime) {
        ArrayList writeStatusList = new ArrayList();
        clusteringPlan.getInputGroups().forEach(inputGroup -> writeStatusList.addAll(this.runClusteringForGroup((HoodieClusteringGroup)inputGroup, clusteringPlan.getStrategy().getStrategyParams(), (Boolean)Option.ofNullable((Object)clusteringPlan.getPreserveHoodieMetadata()).orElse((Object)false), instantTime)));
        HoodieWriteMetadata writeMetadata = new HoodieWriteMetadata();
        writeMetadata.setWriteStatuses((Object)HoodieListData.eager(writeStatusList));
        return writeMetadata;
    }

    public abstract List<WriteStatus> performClusteringWithRecordList(List<HoodieRecord<T>> var1, int var2, String var3, Map<String, String> var4, Schema var5, List<HoodieFileGroupId> var6, boolean var7);

    protected BulkInsertPartitioner<List<HoodieRecord<T>>> getPartitioner(Map<String, String> strategyParams, Schema schema) {
        if (strategyParams.containsKey(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key())) {
            return new JavaCustomColumnsSortPartitioner(strategyParams.get(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()).split(","), HoodieAvroUtils.addMetadataFields((Schema)schema), this.getWriteConfig().isConsistentLogicalTimestampEnabled());
        }
        return JavaBulkInsertInternalPartitionerFactory.get(this.getWriteConfig().getBulkInsertSortMode());
    }

    private List<WriteStatus> runClusteringForGroup(HoodieClusteringGroup clusteringGroup, Map<String, String> strategyParams, boolean preserveHoodieMetadata, String instantTime) {
        List<HoodieRecord<T>> inputRecords = this.readRecordsForGroup(clusteringGroup, instantTime);
        Schema readerSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(this.getWriteConfig().getSchema()));
        List<HoodieFileGroupId> inputFileIds = clusteringGroup.getSlices().stream().map(info -> new HoodieFileGroupId(info.getPartitionPath(), info.getFileId())).collect(Collectors.toList());
        return this.performClusteringWithRecordList(inputRecords, clusteringGroup.getNumOutputFileGroups(), instantTime, strategyParams, readerSchema, inputFileIds, preserveHoodieMetadata);
    }

    private List<HoodieRecord<T>> readRecordsForGroup(HoodieClusteringGroup clusteringGroup, String instantTime) {
        List<ClusteringOperation> clusteringOps = clusteringGroup.getSlices().stream().map(ClusteringOperation::create).collect(Collectors.toList());
        boolean hasLogFiles = clusteringOps.stream().anyMatch(op -> op.getDeltaFilePaths().size() > 0);
        if (hasLogFiles) {
            return this.readRecordsForGroupWithLogs(clusteringOps, instantTime);
        }
        return this.readRecordsForGroupBaseFiles(clusteringOps);
    }

    private List<HoodieRecord<T>> readRecordsForGroupWithLogs(List<ClusteringOperation> clusteringOps, String instantTime) {
        HoodieWriteConfig config = this.getWriteConfig();
        HoodieTable table = this.getHoodieTable();
        ArrayList records = new ArrayList();
        clusteringOps.forEach(clusteringOp -> {
            long maxMemoryPerCompaction = IOUtils.getMaxMemoryPerCompaction((TaskContextSupplier)new JavaTaskContextSupplier(), (HoodieConfig)config);
            LOG.info((Object)("MaxMemoryPerCompaction run as part of clustering => " + maxMemoryPerCompaction));
            try {
                Schema readerSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(config.getSchema()));
                HoodieMergedLogRecordScanner scanner = HoodieMergedLogRecordScanner.newBuilder().withFileSystem((FileSystem)table.getMetaClient().getFs()).withBasePath(table.getMetaClient().getBasePath()).withLogFilePaths(clusteringOp.getDeltaFilePaths()).withReaderSchema(readerSchema).withLatestInstantTime(instantTime).withMaxMemorySizeInBytes(Long.valueOf(maxMemoryPerCompaction)).withReadBlocksLazily(config.getCompactionLazyBlockReadEnabled().booleanValue()).withReverseReader(config.getCompactionReverseLogReadEnabled().booleanValue()).withBufferSize(config.getMaxDFSStreamBufferSize()).withSpillableMapBasePath(config.getSpillableMapBasePath()).withPartition(clusteringOp.getPartitionPath()).withDiskMapType(config.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(config.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).build();
                Option baseFileReader = StringUtils.isNullOrEmpty((String)clusteringOp.getDataFilePath()) ? Option.empty() : Option.of((Object)HoodieFileReaderFactory.getFileReader((Configuration)table.getHadoopConf(), (Path)new Path(clusteringOp.getDataFilePath())));
                HoodieTableConfig tableConfig = table.getMetaClient().getTableConfig();
                HoodieFileSliceReader fileSliceReader = HoodieFileSliceReader.getFileSliceReader((Option)baseFileReader, (HoodieMergedLogRecordScanner)scanner, (Schema)readerSchema, (String)tableConfig.getPayloadClass(), (String)tableConfig.getPreCombineField(), (Option)(tableConfig.populateMetaFields() ? Option.empty() : Option.of((Object)Pair.of((Object)tableConfig.getRecordKeyFieldProp(), (Object)tableConfig.getPartitionFieldProp()))));
                fileSliceReader.forEachRemaining(records::add);
            }
            catch (IOException e) {
                throw new HoodieClusteringException("Error reading input data for " + clusteringOp.getDataFilePath() + " and " + clusteringOp.getDeltaFilePaths(), (Throwable)e);
            }
        });
        return records;
    }

    private List<HoodieRecord<T>> readRecordsForGroupBaseFiles(List<ClusteringOperation> clusteringOps) {
        ArrayList<HoodieRecord<T>> records = new ArrayList<HoodieRecord<T>>();
        clusteringOps.forEach(clusteringOp -> {
            try {
                Schema readerSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(this.getWriteConfig().getSchema()));
                HoodieFileReader baseFileReader = HoodieFileReaderFactory.getFileReader((Configuration)this.getHoodieTable().getHadoopConf(), (Path)new Path(clusteringOp.getDataFilePath()));
                ClosableIterator recordIterator = baseFileReader.getRecordIterator(readerSchema);
                recordIterator.forEachRemaining(record -> records.add(this.transform((IndexedRecord)record)));
            }
            catch (IOException e) {
                throw new HoodieClusteringException("Error reading input data for " + clusteringOp.getDataFilePath() + " and " + clusteringOp.getDeltaFilePaths(), (Throwable)e);
            }
        });
        return records;
    }

    private HoodieRecord<T> transform(IndexedRecord indexedRecord) {
        GenericRecord record = (GenericRecord)indexedRecord;
        Option keyGeneratorOpt = Option.empty();
        String key = KeyGenUtils.getRecordKeyFromGenericRecord((GenericRecord)record, (Option)keyGeneratorOpt);
        String partition = KeyGenUtils.getPartitionPathFromGenericRecord((GenericRecord)record, (Option)keyGeneratorOpt);
        HoodieKey hoodieKey = new HoodieKey(key, partition);
        RewriteAvroPayload avroPayload = new RewriteAvroPayload(record);
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(hoodieKey, (HoodieRecordPayload)avroPayload);
        return hoodieRecord;
    }
}

