/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.Assert;

public class CompressedWALTestBase {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final byte[] VALUE = new byte[4180];

    public void doTest(TableName tableName) throws Exception {
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(tableName.getName(), 0);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        int total = 1000;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] value = VALUE;
        WALFactory wals = new WALFactory(TEST_UTIL.getConfiguration(), tableName.getNameAsString());
        WAL wal = wals.getWAL(regionInfo);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        for (int i = 0; i < 1000; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(row, family, Bytes.toBytes((int)i), value));
            wal.appendData(regionInfo, new WALKeyImpl(regionInfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc, scopes), kvs);
        }
        wal.sync();
        Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
        wals.shutdown();
        WAL.Reader reader = wals.createReader(TEST_UTIL.getTestFileSystem(), walPath);
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (reader.next(entry) != null) {
            ++count;
            ArrayList cells = entry.getEdit().getCells();
            Assert.assertTrue((String)"Should be one KV per WALEdit", (cells.size() == 1 ? 1 : 0) != 0);
            for (Cell cell : cells) {
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])row, (int)0, (int)row.length));
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])family, (int)0, (int)family.length));
                Assert.assertTrue((String)"Incorrect value", (boolean)Bytes.equals((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])value, (int)0, (int)value.length));
            }
        }
        Assert.assertEquals((String)"Should have read back as many KVs as written", (long)1000L, (long)count);
        reader.close();
    }

    static {
        int off = 0;
        Arrays.fill(VALUE, off++, off, (byte)65);
        Arrays.fill(VALUE, off++, off, (byte)66);
        Arrays.fill(VALUE, off, off += 2, (byte)67);
        Arrays.fill(VALUE, off, off += 3, (byte)68);
        Arrays.fill(VALUE, off, off += 5, (byte)69);
        Arrays.fill(VALUE, off, off += 8, (byte)70);
        Arrays.fill(VALUE, off, off += 13, (byte)71);
        Arrays.fill(VALUE, off, off += 21, (byte)72);
        Arrays.fill(VALUE, off, off += 34, (byte)73);
        Arrays.fill(VALUE, off, off += 55, (byte)74);
        Arrays.fill(VALUE, off, off += 89, (byte)75);
        Arrays.fill(VALUE, off, off += 144, (byte)76);
        Arrays.fill(VALUE, off, off += 233, (byte)77);
        Arrays.fill(VALUE, off, off += 377, (byte)78);
        Arrays.fill(VALUE, off, off += 610, (byte)79);
        Arrays.fill(VALUE, off, off += 987, (byte)80);
        Arrays.fill(VALUE, off, off += 1597, (byte)81);
    }
}

