/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestCompactSplitThread {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactSplitThread.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactSplitThread.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
    private final byte[] family = Bytes.toBytes((String)"f");
    private static final int NUM_RS = 1;
    private static final int blockingStoreFiles = 3;
    private static Path rootDir;
    private static FileSystem fs;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestCompactSplitThread.setupConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(1);
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        rootDir = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hstore.compaction.min", 2);
        conf.setInt("hbase.hstore.compactionThreshold", 5);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.blockingStoreFiles", 3);
        conf.setInt("hbase.regionserver.thread.compaction.large", 3);
        conf.setInt("hbase.regionserver.thread.compaction.small", 4);
        conf.setInt("hbase.regionserver.thread.split", 5);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            TEST_UTIL.shutdownMiniCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPoolSizeTuning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            HTableDescriptor htd = new HTableDescriptor(this.tableName);
            htd.addFamily(new HColumnDescriptor(this.family));
            htd.setCompactionEnabled(false);
            TEST_UTIL.getAdmin().createTable((TableDescriptor)htd);
            TEST_UTIL.waitTableAvailable(this.tableName);
            HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(this.tableName);
            Assert.assertEquals((long)3L, (long)regionServer.getCompactSplitThread().getLargeCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.getCompactSplitThread().getSmallCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.getCompactSplitThread().getSplitThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 4);
            conf.setInt("hbase.regionserver.thread.compaction.small", 5);
            conf.setInt("hbase.regionserver.thread.split", 6);
            try {
                regionServer.getCompactSplitThread().onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update bigger configuration failed!");
            }
            Assert.assertEquals((long)4L, (long)regionServer.getCompactSplitThread().getLargeCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.getCompactSplitThread().getSmallCompactionThreadNum());
            Assert.assertEquals((long)6L, (long)regionServer.getCompactSplitThread().getSplitThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 2);
            conf.setInt("hbase.regionserver.thread.compaction.small", 3);
            conf.setInt("hbase.regionserver.thread.split", 4);
            try {
                regionServer.getCompactSplitThread().onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update smaller configuration failed!");
            }
            Assert.assertEquals((long)2L, (long)regionServer.getCompactSplitThread().getLargeCompactionThreadNum());
            Assert.assertEquals((long)3L, (long)regionServer.getCompactSplitThread().getSmallCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.getCompactSplitThread().getSplitThreadNum());
        }
    }

    @Test
    public void testFlushWithTableCompactionDisabled() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.setCompactionEnabled(false);
        TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])new byte[][]{this.family}, null);
        for (int i = 0; i < 4; ++i) {
            TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(this.tableName), this.family);
            TEST_UTIL.flush(this.tableName);
        }
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)this.tableName);
        ArrayList<String> hfiles = SnapshotTestingUtils.listHFileNames(fs, tableDir);
        assert (hfiles.size() > 4);
    }
}

