/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestHelper;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.After;
import org.junit.Before;

public class RegionProcedureStoreTestBase {
    protected HBaseCommonTestingUtility htu;
    protected MasterRegion region;
    protected RegionProcedureStore store;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        Configuration conf = this.htu.getConfiguration();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        Path testDir = this.htu.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)this.htu.getConfiguration(), (Path)testDir);
        Server server = RegionProcedureStoreTestHelper.mockServer(conf);
        this.region = MasterRegionFactory.create((Server)server);
        this.store = RegionProcedureStoreTestHelper.createStore(server, this.region, (ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
    }

    @After
    public void tearDown() throws IOException {
        this.store.stop(true);
        this.region.close(true);
        this.htu.cleanupTestDir();
    }
}

