/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestCatalogJanitorCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogJanitorCluster.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogJanitorCluster.class);
    @Rule
    public final TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName T1 = TableName.valueOf((String)"t1");
    private static final TableName T2 = TableName.valueOf((String)"t2");
    private static final TableName T3 = TableName.valueOf((String)"t3");
    private static final TableName T4 = TableName.valueOf((String)"t4");
    private static final TableName T5 = TableName.valueOf((String)"t5");

    @Before
    public void before() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createMultiRegionTable(T1, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.createMultiRegionTable(T2, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.createMultiRegionTable(T3, new byte[][]{HConstants.CATALOG_FAMILY});
        byte[][] keysForT4 = new byte[][]{Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"bb"), Bytes.toBytes((String)"cc"), Bytes.toBytes((String)"dd")};
        TEST_UTIL.createTable(T4, HConstants.CATALOG_FAMILY, (byte[][])keysForT4);
        byte[][] keysForT5 = new byte[][]{Bytes.toBytes((String)"bb"), Bytes.toBytes((String)"cc"), Bytes.toBytes((String)"dd")};
        TEST_UTIL.createTable(T5, HConstants.CATALOG_FAMILY, (byte[][])keysForT5);
    }

    @After
    public void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testConsistency() throws IOException {
        CatalogJanitor janitor = TEST_UTIL.getHBaseCluster().getMaster().getCatalogJanitor();
        RegionStateStore regionStateStore = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        janitor.scan();
        CatalogJanitorReport report = janitor.getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        List t2Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T2);
        regionStateStore.deleteRegion((RegionInfo)t2Ris.get(0));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        Assert.assertEquals((long)1L, (long)report.getHoles().size());
        Assert.assertTrue((boolean)((RegionInfo)((Pair)report.getHoles().get(0)).getFirst()).getTable().equals((Object)RegionInfoBuilder.UNDEFINED.getTable()));
        Assert.assertTrue((boolean)((RegionInfo)((Pair)report.getHoles().get(0)).getSecond()).getTable().equals((Object)T2));
        Assert.assertEquals((long)0L, (long)report.getOverlaps().size());
        List t3Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T3);
        RegionInfo ri = (RegionInfo)t3Ris.get(0);
        RegionInfo newRi1 = RegionInfoBuilder.newBuilder((TableName)ri.getTable()).setStartKey(TestCatalogJanitorCluster.incrementRow(ri.getStartKey())).setEndKey(TestCatalogJanitorCluster.incrementRow(ri.getEndKey())).build();
        Put p1 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRi1, (long)EnvironmentEdgeManager.currentTime());
        RegionInfo newRi2 = RegionInfoBuilder.newBuilder((TableName)newRi1.getTable()).setStartKey(TestCatalogJanitorCluster.incrementRow(newRi1.getStartKey())).setEndKey(TestCatalogJanitorCluster.incrementRow(newRi1.getEndKey())).build();
        Put p2 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRi2, (long)EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(p1, p2));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        Assert.assertEquals((long)3L, (long)report.getOverlaps().size());
        Assert.assertEquals((long)1L, (long)report.getHoles().size());
        Assert.assertTrue((boolean)report.getEmptyRegionInfo().isEmpty());
        Assert.assertTrue((boolean)report.getUnknownServers().isEmpty());
        List t1Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T1);
        RegionInfo t1Ri1 = (RegionInfo)t1Ris.get(1);
        Put pServer = new Put(t1Ri1.getRegionName());
        pServer.addColumn(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)0), Bytes.toBytes((String)"bad.server.example.org:1234"));
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(pServer));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        Assert.assertEquals((long)1L, (long)report.getUnknownServers().size());
        LOG.info("Make null info:server");
        Put emptyInfoServerPut = new Put(t1Ri1.getRegionName());
        emptyInfoServerPut.addColumn(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)0), Bytes.toBytes((String)""));
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(emptyInfoServerPut));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((long)0L, (long)report.getUnknownServers().size());
        RegionInfo t1Ri2 = (RegionInfo)t1Ris.get(2);
        Put pEmptyRI = new Put(t1Ri2.getRegionName());
        pEmptyRI.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, HConstants.EMPTY_BYTE_ARRAY);
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(pEmptyRI));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((long)1L, (long)report.getEmptyRegionInfo().size());
        int holesReported = report.getHoles().size();
        int overlapsReported = report.getOverlaps().size();
        List t4Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T4);
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)((RegionInfo)t4Ris.get(2)));
        RegionInfo newRiT4 = RegionInfoBuilder.newBuilder((TableName)T4).setStartKey("a".getBytes()).setEndKey("cc".getBytes()).build();
        Put putForT4 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRiT4, (long)EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(putForT4));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((long)holesReported, (long)report.getHoles().size());
        Assert.assertEquals((long)(overlapsReported + 2), (long)report.getOverlaps().size());
        holesReported = report.getHoles().size();
        overlapsReported = report.getOverlaps().size();
        List t5Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T5);
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)((RegionInfo)t5Ris.get(2)));
        RegionInfo newRiT5 = RegionInfoBuilder.newBuilder((TableName)T5).setStartKey("a".getBytes()).setEndKey("g".getBytes()).build();
        Put putForT5 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRiT5, (long)EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(putForT5));
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((long)holesReported, (long)report.getHoles().size());
        Assert.assertEquals((long)(overlapsReported + 3), (long)report.getOverlaps().size());
    }

    private static byte[] incrementRow(byte[] row) {
        if (row.length == 0) {
            return new byte[]{48};
        }
        row[row.length - 1] = (byte)(row[row.length - 1] + 1);
        return row;
    }

    @Test
    public void testHoles() throws IOException {
        CatalogJanitor janitor = TEST_UTIL.getHBaseCluster().getMaster().getCatalogJanitor();
        CatalogJanitorReport report = janitor.getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        this.verifyCornerHoles(janitor, T1);
        this.verifyCornerHoles(janitor, T2);
        this.verifyMiddleHole(janitor);
        this.fixHoles(janitor);
    }

    private void fixHoles(CatalogJanitor janitor) throws IOException {
        MetaFixer metaFixer = new MetaFixer((MasterServices)TEST_UTIL.getHBaseCluster().getMaster());
        janitor.scan();
        CatalogJanitorReport report = janitor.getLastReport();
        Assert.assertEquals((String)"Number of holes are not matching", (long)5L, (long)report.getHoles().size());
        metaFixer.fix();
        janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((String)"Holes are not fixed", (long)0L, (long)report.getHoles().size());
    }

    private void verifyMiddleHole(CatalogJanitor janitor) throws IOException {
        RegionInfo firstRegion = this.getRegionInfo(T3, "".getBytes());
        RegionInfo secondRegion = this.getRegionInfo(T3, "bbb".getBytes());
        RegionInfo thirdRegion = this.getRegionInfo(T3, "ccc".getBytes());
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)secondRegion);
        LinkedList<Pair<RegionInfo, RegionInfo>> holes = this.getHoles(janitor, T3);
        Pair<RegionInfo, RegionInfo> regionInfoRegionInfoPair = holes.getFirst();
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getFirst()).getTable().equals((Object)T3));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getSecond()).getTable().equals((Object)T3));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getFirst()).getEncodedName().equals(firstRegion.getEncodedName()));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getSecond()).getEncodedName().equals(thirdRegion.getEncodedName()));
    }

    private void verifyCornerHoles(CatalogJanitor janitor, TableName tableName) throws IOException {
        RegionInfo firstRegion = this.getRegionInfo(tableName, "".getBytes());
        RegionInfo secondRegion = this.getRegionInfo(tableName, "bbb".getBytes());
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)firstRegion);
        LinkedList<Pair<RegionInfo, RegionInfo>> holes = this.getHoles(janitor, tableName);
        Assert.assertEquals((long)1L, (long)holes.size());
        Pair<RegionInfo, RegionInfo> regionInfoRegionInfoPair = holes.get(0);
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getFirst()).getTable().equals((Object)RegionInfoBuilder.UNDEFINED.getTable()));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getSecond()).getTable().equals((Object)tableName));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getSecond()).getEncodedName().equals(secondRegion.getEncodedName()));
        RegionInfo lastRegion = this.getRegionInfo(tableName, "zzz".getBytes());
        RegionInfo secondLastRegion = this.getRegionInfo(tableName, "yyy".getBytes());
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)lastRegion);
        holes = this.getHoles(janitor, tableName);
        Assert.assertEquals((long)2L, (long)holes.size());
        regionInfoRegionInfoPair = holes.get(1);
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getFirst()).getEncodedName().equals(secondLastRegion.getEncodedName()));
        Assert.assertTrue((boolean)((RegionInfo)regionInfoRegionInfoPair.getSecond()).getTable().equals((Object)RegionInfoBuilder.UNDEFINED.getTable()));
    }

    private LinkedList<Pair<RegionInfo, RegionInfo>> getHoles(CatalogJanitor janitor, TableName tableName) throws IOException {
        janitor.scan();
        CatalogJanitorReport lastReport = janitor.getLastReport();
        Assert.assertFalse((boolean)lastReport.isEmpty());
        LinkedList<Pair<RegionInfo, RegionInfo>> holes = new LinkedList<Pair<RegionInfo, RegionInfo>>();
        for (Pair hole : lastReport.getHoles()) {
            if (!((RegionInfo)hole.getFirst()).getTable().equals((Object)tableName) && !((RegionInfo)hole.getSecond()).getTable().equals((Object)tableName)) continue;
            holes.add((Pair<RegionInfo, RegionInfo>)hole);
        }
        return holes;
    }

    private RegionInfo getRegionInfo(TableName tableName, byte[] row) throws IOException {
        RegionInfo regionInfo = TEST_UTIL.getConnection().getRegionLocator(tableName).getRegionLocation(row).getRegion();
        Assert.assertNotNull((Object)regionInfo);
        return regionInfo;
    }
}

